/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.spatial;

import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.AbstractNeighborhoodOutlier;
import de.lmu.ifi.dbs.elki.algorithm.outlier.spatial.neighborhood.NeighborSetPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.linearalgebra.CovarianceMatrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.result.outlier.BasicOutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;

@Title(value="Scatterplot Spatial Outlier")
@Description(value="Spatial Outlier Detection Algorithm using linear regression of attributes and the mean of their neighbors.")
@Reference(authors="S. Shekhar and C.-T. Lu and P. Zhang", title="A Unified Approach to Detecting Spatial Outliers", booktitle="GeoInformatica 7-2, 2003", url="http://dx.doi.org/10.1023/A:1023455925009")
public class CTLuScatterplotOutlier<N>
extends AbstractNeighborhoodOutlier<N> {
    private static final Logging LOG = Logging.getLogger(CTLuScatterplotOutlier.class);

    public CTLuScatterplotOutlier(NeighborSetPredicate.Factory<N> factory) {
        super(factory);
    }

    public OutlierResult run(Database database, Relation<N> relation, Relation<? extends NumberVector> relation2) {
        double d;
        double d2;
        Object object;
        NeighborSetPredicate neighborSetPredicate = this.getNeighborSetPredicateFactory().instantiate(database, relation);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 1);
        CovarianceMatrix covarianceMatrix = new CovarianceMatrix(2);
        DBIDIter dBIDIter = relation2.iterDBIDs();
        while (dBIDIter.valid()) {
            double d3 = relation2.get(dBIDIter).doubleValue(0);
            Mean mean = new Mean();
            object = neighborSetPredicate.getNeighborDBIDs(dBIDIter);
            DBIDIter dBIDIter2 = object.iter();
            while (dBIDIter2.valid()) {
                if (!DBIDUtil.equal(dBIDIter, dBIDIter2)) {
                    mean.put(relation2.get(dBIDIter2).doubleValue(0));
                }
                dBIDIter2.advance();
            }
            double d4 = mean.getCount() > 0.0 ? mean.getMean() : d3;
            writableDoubleDataStore.putDouble(dBIDIter, d4);
            covarianceMatrix.put(new double[]{d3, d4});
            dBIDIter.advance();
        }
        object = covarianceMatrix.getMeanVector().getArrayRef();
        Object object2 = covarianceMatrix.destroyToSampleMatrix();
        double d5 = ((Matrix)object2).get(0, 0);
        double d6 = ((Matrix)object2).get(0, 1);
        double d7 = d6 / d5;
        reference var9_19 = object[1] - d7 * object[0];
        object = DataStoreUtil.makeDoubleStorage(relation2.getDBIDs(), 4);
        object2 = new MeanVariance();
        Object object3 = relation2.iterDBIDs();
        while (object3.valid()) {
            d2 = relation2.get((DBIDRef)object3).doubleValue(0);
            d = writableDoubleDataStore.doubleValue((DBIDRef)object3) - (d7 * d2 + var9_19);
            object.putDouble((DBIDRef)object3, d);
            ((MeanVariance)object2).put(d);
            object3.advance();
        }
        object3 = new DoubleMinMax();
        d2 = ((MeanVariance)object2).getMean();
        d = ((MeanVariance)object2).getNaiveStddev();
        DBIDIter dBIDIter3 = relation2.iterDBIDs();
        while (dBIDIter3.valid()) {
            double d8 = Math.abs((object.doubleValue(dBIDIter3) - d2) / d);
            ((DoubleMinMax)object3).put(d8);
            object.putDouble(dBIDIter3, d8);
            dBIDIter3.advance();
        }
        MaterializedDoubleRelation materializedDoubleRelation = new MaterializedDoubleRelation("SPO", "Scatterplot-Outlier", (DoubleDataStore)object, relation2.getDBIDs());
        BasicOutlierScoreMeta basicOutlierScoreMeta = new BasicOutlierScoreMeta(((DoubleMinMax)object3).getMin(), ((DoubleMinMax)object3).getMax(), 0.0, Double.POSITIVE_INFINITY, 0.0);
        OutlierResult outlierResult = new OutlierResult(basicOutlierScoreMeta, materializedDoubleRelation);
        outlierResult.addChildResult(neighborSetPredicate);
        return outlierResult;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getNeighborSetPredicateFactory().getInputTypeRestriction(), TypeUtil.NUMBER_VECTOR_FIELD_1D);
    }

    public static class Parameterizer<N>
    extends AbstractNeighborhoodOutlier.Parameterizer<N> {
        @Override
        protected CTLuScatterplotOutlier<N> makeInstance() {
            return new CTLuScatterplotOutlier(this.npredf);
        }
    }
}

