/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data;

import de.lmu.ifi.dbs.elki.data.AbstractNumberVector;
import de.lmu.ifi.dbs.elki.data.SparseNumberVector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import gnu.trove.iterator.TIntDoubleIterator;
import gnu.trove.map.TIntDoubleMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class SparseDoubleVector
extends AbstractNumberVector
implements SparseNumberVector {
    public static final Factory FACTORY = new Factory();
    public static final ByteBufferSerializer<SparseDoubleVector> VARIABLE_SERIALIZER = new VariableSerializer();
    private final int[] indexes;
    private final double[] values;
    private int dimensionality;

    public SparseDoubleVector(int[] nArray, double[] dArray, int n) {
        this.indexes = nArray;
        this.values = dArray;
        this.dimensionality = n;
    }

    public SparseDoubleVector(TIntDoubleMap tIntDoubleMap, int n) throws IllegalArgumentException {
        int n2;
        if (tIntDoubleMap.size() > n) {
            throw new IllegalArgumentException("values.size() > dimensionality!");
        }
        this.indexes = new int[tIntDoubleMap.size()];
        this.values = new double[tIntDoubleMap.size()];
        TIntDoubleIterator tIntDoubleIterator = tIntDoubleMap.iterator();
        int n3 = 0;
        while (tIntDoubleIterator.hasNext()) {
            tIntDoubleIterator.advance();
            this.indexes[n3] = tIntDoubleIterator.key();
            ++n3;
        }
        Arrays.sort(this.indexes);
        for (n2 = 0; n2 < tIntDoubleMap.size(); ++n2) {
            this.values[n2] = tIntDoubleMap.get(this.indexes[n2]);
        }
        this.dimensionality = n;
        n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
    }

    private int getMaxDim() {
        if (this.indexes.length == 0) {
            return 0;
        }
        return this.indexes[this.indexes.length - 1];
    }

    public SparseDoubleVector(double[] dArray) throws IllegalArgumentException {
        int n;
        this.dimensionality = dArray.length;
        int n2 = 0;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] == 0.0) continue;
            ++n2;
        }
        this.indexes = new int[n2];
        this.values = new double[n2];
        n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            double d = dArray[i];
            if (d == 0.0) continue;
            this.indexes[n] = i;
            this.values[n] = d;
            ++n;
        }
    }

    @Override
    public int getDimensionality() {
        return this.dimensionality;
    }

    @Override
    public void setDimensionality(int n) throws IllegalArgumentException {
        int n2 = this.getMaxDim();
        if (n2 > n) {
            throw new IllegalArgumentException("Given dimensionality " + n + " is too small w.r.t. the given values (occurring maximum: " + n2 + ").");
        }
        this.dimensionality = n;
    }

    @Override
    @Deprecated
    public Double getValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public double doubleValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return this.values[n2];
        }
        return 0.0;
    }

    @Override
    @Deprecated
    public long longValue(int n) {
        int n2 = Arrays.binarySearch(this.indexes, n);
        if (n2 >= 0) {
            return (long)this.values[n2];
        }
        return 0L;
    }

    @Override
    public Vector getColumnVector() {
        return new Vector(this.getValues());
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.indexes.length);
        for (int i = 0; i < this.indexes.length; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append(this.indexes[i]);
            stringBuilder.append(" ");
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    private double[] getValues() {
        double[] dArray = new double[this.dimensionality];
        for (int i = 0; i < this.indexes.length; ++i) {
            dArray[this.indexes[i]] = this.values[i];
        }
        return dArray;
    }

    @Override
    public int iter() {
        return 0;
    }

    @Override
    public int iterDim(int n) {
        return this.indexes[n];
    }

    @Override
    public int iterAdvance(int n) {
        return n + 1;
    }

    @Override
    public boolean iterValid(int n) {
        return n < this.indexes.length;
    }

    @Override
    public double iterDoubleValue(int n) {
        return this.values[n];
    }

    @Override
    public float iterFloatValue(int n) {
        return (float)this.values[n];
    }

    @Override
    public int iterIntValue(int n) {
        return (int)this.values[n];
    }

    @Override
    public short iterShortValue(int n) {
        return (short)this.values[n];
    }

    @Override
    public long iterLongValue(int n) {
        return (long)this.values[n];
    }

    @Override
    public byte iterByteValue(int n) {
        return (byte)this.values[n];
    }

    public static class VariableSerializer
    implements ByteBufferSerializer<SparseDoubleVector> {
        @Override
        public SparseDoubleVector fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
            int n = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int n2 = ByteArrayUtil.readUnsignedVarint(byteBuffer);
            int[] nArray = new int[n2];
            double[] dArray = new double[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = ByteArrayUtil.readUnsignedVarint(byteBuffer);
                dArray[i] = byteBuffer.getDouble();
            }
            return new SparseDoubleVector(nArray, dArray, n);
        }

        @Override
        public void toByteBuffer(ByteBuffer byteBuffer, SparseDoubleVector sparseDoubleVector) throws IOException {
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseDoubleVector.dimensionality);
            ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseDoubleVector.values.length);
            for (int i = 0; i < sparseDoubleVector.values.length; ++i) {
                ByteArrayUtil.writeUnsignedVarint(byteBuffer, sparseDoubleVector.indexes[i]);
                byteBuffer.putDouble(sparseDoubleVector.values[i]);
            }
        }

        @Override
        public int getByteSize(SparseDoubleVector sparseDoubleVector) {
            int n = 0;
            n += ByteArrayUtil.getUnsignedVarintSize(sparseDoubleVector.dimensionality);
            n += ByteArrayUtil.getUnsignedVarintSize(sparseDoubleVector.values.length);
            for (int n2 : sparseDoubleVector.indexes) {
                n += ByteArrayUtil.getUnsignedVarintSize(n2);
            }
            return n += sparseDoubleVector.values.length * 8;
        }
    }

    public static class Factory
    extends AbstractNumberVector.Factory<SparseDoubleVector>
    implements SparseNumberVector.Factory<SparseDoubleVector> {
        @Override
        public <A> SparseDoubleVector newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            int n = arrayAdapter.size(a);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = arrayAdapter.get(a, i).doubleValue();
            }
            return new SparseDoubleVector(dArray);
        }

        @Override
        public <A> SparseDoubleVector newNumberVector(A a, NumberArrayAdapter<?, ? super A> numberArrayAdapter) {
            int n = numberArrayAdapter.size(a);
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = numberArrayAdapter.getDouble(a, i);
            }
            return new SparseDoubleVector(dArray);
        }

        @Override
        public SparseDoubleVector newNumberVector(TIntDoubleMap tIntDoubleMap, int n) {
            return new SparseDoubleVector(tIntDoubleMap, n);
        }

        @Override
        public ByteBufferSerializer<SparseDoubleVector> getDefaultSerializer() {
            return VARIABLE_SERIALIZER;
        }

        @Override
        public Class<? super SparseDoubleVector> getRestrictionClass() {
            return SparseDoubleVector.class;
        }

        public static class Parameterizer
        extends AbstractParameterizer {
            @Override
            protected Factory makeInstance() {
                return FACTORY;
            }
        }
    }
}

