/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.uncertain.AbstractUncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.DiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

@Reference(authors="N. Dalvi, C. R\u00e9, D. Suciu", title="Probabilistic databases: diamonds in the dirt", booktitle="Communications of the ACM 52, 7", url="http://dx.doi.org/10.1145/1538788.1538810")
public class UnweightedDiscreteUncertainObject
extends AbstractUncertainObject
implements DiscreteUncertainObject {
    public static final FeatureVector.Factory<UnweightedDiscreteUncertainObject, ?> FACTORY = new Factory();
    private DoubleVector[] samples;

    public UnweightedDiscreteUncertainObject(DoubleVector[] doubleVectorArray) {
        if (doubleVectorArray.length == 0) {
            throw new AbortException("Discrete Uncertain Objects must have at least one point.");
        }
        this.samples = doubleVectorArray;
        this.bounds = UnweightedDiscreteUncertainObject.computeBounds(doubleVectorArray);
    }

    @Override
    public DoubleVector drawSample(Random random) {
        return this.samples[random.nextInt(this.samples.length)];
    }

    @Override
    public DoubleVector getCenterOfMass() {
        int n;
        int n2 = this.getDimensionality();
        double[] dArray = new double[n2];
        for (n = 0; n < this.samples.length; ++n) {
            DoubleVector doubleVector = this.samples[n];
            for (int i = 0; i < n2; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + doubleVector.doubleValue(i);
            }
        }
        n = 0;
        while (n < n2) {
            int n4 = n++;
            dArray[n4] = dArray[n4] / (double)this.samples.length;
        }
        return new DoubleVector(dArray);
    }

    @Override
    public int getNumberSamples() {
        return this.samples.length;
    }

    @Override
    public DoubleVector getSample(int n) {
        return this.samples[n];
    }

    @Override
    public double getWeight(int n) {
        return 1.0 / (double)this.samples.length;
    }

    private static class Factory
    implements FeatureVector.Factory<UnweightedDiscreteUncertainObject, Number> {
        private Factory() {
        }

        @Override
        public <A> UnweightedDiscreteUncertainObject newFeatureVector(A a, ArrayAdapter<? extends Number, A> arrayAdapter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBufferSerializer<UnweightedDiscreteUncertainObject> getDefaultSerializer() {
            return null;
        }

        @Override
        public Class<? super UnweightedDiscreteUncertainObject> getRestrictionClass() {
            return UnweightedDiscreteUncertainObject.class;
        }
    }
}

