/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier;

import de.lmu.ifi.dbs.elki.data.uncertain.UncertainObject;
import de.lmu.ifi.dbs.elki.data.uncertain.uncertainifier.Uncertainifier;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class AbstractDiscreteUncertainifier<UO extends UncertainObject>
implements Uncertainifier<UO> {
    protected Uncertainifier<?> inner;
    protected int minQuant;
    protected int maxQuant;

    public AbstractDiscreteUncertainifier(Uncertainifier<?> uncertainifier, int n, int n2) {
        this.inner = uncertainifier;
        this.minQuant = n;
        this.maxQuant = n2;
    }

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final int DEFAULT_SAMPLE_SIZE = 10;
        public static final OptionID INNER_ID = new OptionID("uo.discrete.generator", "Class to generate the point distribution.");
        public static final OptionID MULT_MAX_ID = new OptionID("uo.quantity.max", "Maximum points per uncertain object.");
        public static final OptionID MULT_MIN_ID = new OptionID("uo.quantity.min", "Minimum points per uncertain object (defaults to maximum.");
        protected Uncertainifier<?> inner;
        protected int minQuant;
        protected int maxQuant;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            IntParameter intParameter2;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(INNER_ID, Uncertainifier.class);
            if (parameterization.grab(objectParameter)) {
                this.inner = (Uncertainifier)objectParameter.instantiateClass(parameterization);
                if (this.inner instanceof AbstractDiscreteUncertainifier) {
                    LoggingUtil.warning("Using a discrete uncertainifier inside a discrete uncertainifier is likely a configuration error, and is likely to produce too many duplicate points. Did you mean to use a uniform or gaussian distribution instead?");
                }
            }
            if (parameterization.grab(intParameter2 = new IntParameter(MULT_MAX_ID, 10))) {
                this.maxQuant = intParameter2.intValue();
            }
            this.minQuant = parameterization.grab(intParameter = (IntParameter)new IntParameter(MULT_MIN_ID).setOptional(true)) ? intParameter.intValue() : this.maxQuant;
        }
    }
}

