/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.evaluation.similaritymatrix;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.evaluation.Evaluator;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.math.DoubleMinMax;
import de.lmu.ifi.dbs.elki.result.OrderingResult;
import de.lmu.ifi.dbs.elki.result.PixmapResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.LinearScaling;
import de.lmu.ifi.dbs.elki.utilities.scaling.ScalingFunction;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class ComputeSimilarityMatrixImage<O>
implements Evaluator {
    private static final Logging LOG = Logging.getLogger(ComputeSimilarityMatrixImage.class);
    public static final OptionID SCALING_ID = new OptionID("simmatrix.scaling", "Class to use as scaling function.");
    public static final OptionID SKIPZERO_ID = new OptionID("simmatrix.skipzero", "Skip zero values when computing the colors to increase contrast.");
    private DistanceFunction<? super O> distanceFunction;
    private ScalingFunction scaling;
    private boolean skipzero = false;

    public ComputeSimilarityMatrixImage(DistanceFunction<? super O> distanceFunction, ScalingFunction scalingFunction, boolean bl) {
        this.distanceFunction = distanceFunction;
        this.scaling = scalingFunction;
        this.skipzero = bl;
    }

    private SimilarityMatrix computeSimilarityMatrixImage(Relation<O> relation, DBIDIter dBIDIter) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(relation.size());
        while (dBIDIter.valid()) {
            arrayModifiableDBIDs.add(dBIDIter);
            dBIDIter.advance();
        }
        if (arrayModifiableDBIDs.size() != relation.size()) {
            throw new IllegalStateException("Iterable result doesn't match database size - incomplete ordering?");
        }
        DistanceQuery<O> distanceQuery = this.distanceFunction.instantiate(relation);
        int n = arrayModifiableDBIDs.size();
        int n2 = 2 * n;
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Similarity Matrix Image", n2, LOG) : null;
        DoubleMinMax doubleMinMax = new DoubleMinMax();
        DBIDArrayMIter dBIDArrayMIter = arrayModifiableDBIDs.iter();
        DBIDArrayMIter dBIDArrayMIter2 = arrayModifiableDBIDs.iter();
        while (dBIDArrayMIter.valid()) {
            dBIDArrayMIter2.seek(dBIDArrayMIter.getOffset());
            while (dBIDArrayMIter2.valid()) {
                double d = distanceQuery.distance((DBIDRef)dBIDArrayMIter, (DBIDRef)dBIDArrayMIter2);
                if (!(Double.isNaN(d) || Double.isInfinite(d) || this.skipzero && !(d > 0.0))) {
                    doubleMinMax.put(d);
                }
                dBIDArrayMIter2.advance();
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDArrayMIter.advance();
        }
        double d = doubleMinMax.getMax() - doubleMinMax.getMin();
        if (d > 0.0) {
            d = 1.0 / d;
        }
        LinearScaling linearScaling = new LinearScaling(d, -doubleMinMax.getMin() * d);
        BufferedImage bufferedImage = new BufferedImage(n, n, 1);
        DBIDArrayMIter dBIDArrayMIter3 = arrayModifiableDBIDs.iter();
        DBIDArrayMIter dBIDArrayMIter4 = arrayModifiableDBIDs.iter();
        for (int i = 0; i < n && dBIDArrayMIter3.valid(); ++i) {
            dBIDArrayMIter4.seek(dBIDArrayMIter3.getOffset());
            for (int j = i; j < n && dBIDArrayMIter4.valid(); ++j) {
                double d2 = distanceQuery.distance((DBIDRef)dBIDArrayMIter3, (DBIDRef)dBIDArrayMIter4);
                if (d2 > 0.0) {
                    d2 = linearScaling.getScaled(d2);
                }
                if (this.scaling != null) {
                    d2 = this.scaling.getScaled(d2);
                }
                int n3 = 0xFF & (int)(255.0 * d2);
                int n4 = 0xFF000000 | n3 << 16 | n3 << 8 | n3;
                bufferedImage.setRGB(i, j, n4);
                bufferedImage.setRGB(j, i, n4);
                dBIDArrayMIter4.advance();
            }
            LOG.incrementProcessed(finiteProgress);
            dBIDArrayMIter3.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        return new SimilarityMatrix(bufferedImage, relation, arrayModifiableDBIDs);
    }

    @Override
    public void processNewResult(ResultHierarchy resultHierarchy, Result result) {
        Relation relation;
        Result result2;
        Database database = ResultUtil.findDatabase(resultHierarchy);
        boolean bl = true;
        List<OutlierResult> list = ResultUtil.getOutlierResults(result);
        List<OrderingResult> list2 = ResultUtil.getOrderingResults(result);
        for (OutlierResult object : list) {
            result2 = object.getOrdering();
            relation = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
            database.getHierarchy().add(result2, this.computeSimilarityMatrixImage(relation, result2.order(relation.getDBIDs()).iter()));
            list2.remove(result2);
            bl = false;
        }
        for (OrderingResult orderingResult : list2) {
            result2 = database.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
            relation = orderingResult.order(result2.getDBIDs()).iter();
            database.getHierarchy().add(orderingResult, this.computeSimilarityMatrixImage((Relation<O>)result2, (DBIDIter)((Object)relation)));
            bl = false;
        }
        if (bl) {
            ArrayList<Database> arrayList = ResultUtil.filterResults(resultHierarchy, Database.class);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                result2 = (Database)iterator.next();
                relation = result2.getRelation(this.distanceFunction.getInputTypeRestriction(), new Object[0]);
                database.getHierarchy().add(database, this.computeSimilarityMatrixImage(relation, relation.iterDBIDs()));
            }
        }
    }

    public static class Parameterizer<O>
    extends AbstractParameterizer {
        private DistanceFunction<O> distanceFunction;
        private ScalingFunction scaling;
        private boolean skipzero = false;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Flag flag;
            ObjectParameter objectParameter;
            super.makeOptions(parameterization);
            ObjectParameter objectParameter2 = AbstractAlgorithm.makeParameterDistanceFunction(EuclideanDistanceFunction.class, DistanceFunction.class);
            if (parameterization.grab(objectParameter2)) {
                this.distanceFunction = (DistanceFunction)objectParameter2.instantiateClass(parameterization);
            }
            if (parameterization.grab(objectParameter = new ObjectParameter(SCALING_ID, ScalingFunction.class, true))) {
                this.scaling = (ScalingFunction)objectParameter.instantiateClass(parameterization);
            }
            if (parameterization.grab(flag = new Flag(SKIPZERO_ID))) {
                this.skipzero = (Boolean)flag.getValue();
            }
        }

        @Override
        protected ComputeSimilarityMatrixImage<O> makeInstance() {
            return new ComputeSimilarityMatrixImage<O>(this.distanceFunction, this.scaling, this.skipzero);
        }
    }

    public static class SimilarityMatrix
    implements PixmapResult {
        private static final String IMGFILEPREFIX = "elki-pixmap-";
        Relation<?> relation;
        ArrayDBIDs ids;
        RenderedImage img;
        File imgfile = null;

        public SimilarityMatrix(RenderedImage renderedImage, Relation<?> relation, ArrayDBIDs arrayDBIDs) {
            this.img = renderedImage;
            this.relation = relation;
            this.ids = arrayDBIDs;
        }

        @Override
        public RenderedImage getImage() {
            return this.img;
        }

        @Override
        public File getAsFile() {
            if (this.imgfile == null) {
                try {
                    this.imgfile = File.createTempFile(IMGFILEPREFIX, ".png");
                    this.imgfile.deleteOnExit();
                    ImageIO.write(this.img, "PNG", this.imgfile);
                }
                catch (IOException iOException) {
                    LoggingUtil.exception("Could not generate OPTICS plot.", iOException);
                }
            }
            return this.imgfile;
        }

        public Relation<?> getRelation() {
            return this.relation;
        }

        public ArrayDBIDs getIDs() {
            return this.ids;
        }

        @Override
        public String getLongName() {
            return "Similarity Matrix";
        }

        @Override
        public String getShortName() {
            return "sim-matrix";
        }
    }
}

