/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreePopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_SELECTED = "selected";
    public static final String ACTION_CANCELED = "canceled";
    protected JTree tree;
    protected JScrollPane scroller;
    private TreeModel model;
    private Handler handler = new Handler();
    private static Border TREE_BORDER = new LineBorder(Color.BLACK, 1);

    public TreePopup() {
        this(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.tree.setRootVisible(false);
    }

    public TreePopup(TreeModel treeModel) {
        this.setName("TreePopup.popup");
        this.model = treeModel;
        this.tree = this.createTree();
        this.scroller = this.createScroller();
        this.configurePopup();
    }

    protected JTree createTree() {
        JTree jTree = new JTree(this.model);
        jTree.setName("TreePopup.tree");
        jTree.setFont(this.getFont());
        jTree.setForeground(this.getForeground());
        jTree.setBackground(this.getBackground());
        jTree.setBorder(null);
        jTree.setFocusable(true);
        jTree.addMouseListener(this.handler);
        jTree.addKeyListener(this.handler);
        jTree.setCellRenderer(new Renderer());
        return jTree;
    }

    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(TREE_BORDER);
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    protected JScrollPane createScroller() {
        JScrollPane jScrollPane = new JScrollPane(this.tree, 20, 31);
        jScrollPane.setHorizontalScrollBar(null);
        jScrollPane.setName("TreePopup.scrollPane");
        jScrollPane.setFocusable(false);
        jScrollPane.getVerticalScrollBar().setFocusable(false);
        jScrollPane.setBorder(null);
        return jScrollPane;
    }

    public JTree getTree() {
        return this.tree;
    }

    public void show(Component component) {
        Dimension dimension = component.getSize();
        Insets insets = this.getInsets();
        dimension.setSize(dimension.width - (insets.right + insets.left), 10 * dimension.height);
        Dimension dimension2 = this.computePopupBounds(component, 0, this.getBounds().height, dimension.width, dimension.height).getSize();
        this.scroller.setMaximumSize(dimension2);
        this.scroller.setPreferredSize(dimension2);
        this.scroller.setMinimumSize(dimension2);
        super.show(component, 0, component.getHeight());
        this.tree.requestFocusInWindow();
    }

    protected Rectangle computePopupBounds(Component component, int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        Cloneable cloneable;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Point point = new Point();
        SwingUtilities.convertPointFromScreen(point, component);
        if (graphicsConfiguration != null) {
            cloneable = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle = graphicsConfiguration.getBounds();
            rectangle.width -= cloneable.left + cloneable.right;
            rectangle.height -= cloneable.top + cloneable.bottom;
            rectangle.x += point.x + cloneable.left;
            rectangle.y += point.y + cloneable.top;
        } else {
            rectangle = new Rectangle(point, toolkit.getScreenSize());
        }
        cloneable = new Rectangle(n, n2, n3, n4);
        if (n2 + n4 > rectangle.y + rectangle.height && n4 < rectangle.height) {
            ((Rectangle)cloneable).y = -((Rectangle)cloneable).height;
        }
        return cloneable;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected class Handler
    implements MouseListener,
    KeyListener,
    FocusListener {
        protected Handler() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\n') {
                keyEvent.consume();
            }
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_SELECTED, keyEvent.getWhen(), keyEvent.getModifiers()));
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 27) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_CANCELED, keyEvent.getWhen(), keyEvent.getModifiers()));
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_SELECTED, mouseEvent.getWhen(), mouseEvent.getModifiers()));
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            TreePopup.this.fireActionPerformed(new ActionEvent(TreePopup.this, 1001, TreePopup.ACTION_CANCELED));
        }
    }

    public class Renderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 1L;
        JLabel label;
        private Color selbg = UIManager.getColor("Tree.selectionBackground");
        private Color defbg = UIManager.getColor("Tree.textBackground");
        private Color selfg = UIManager.getColor("Tree.selectionForeground");
        private Color deffg = UIManager.getColor("Tree.textForeground");
        private Icon leafIcon;
        private Icon folderIcon;

        protected Renderer() {
            this.setLayout(new BorderLayout());
            this.label = new JLabel("This should never be rendered.");
            this.add(this.label);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            this.label.setText((String)((DefaultMutableTreeNode)object).getUserObject());
            this.setForeground(bl ? this.selfg : this.deffg);
            this.setBackground(bl ? this.selbg : this.defbg);
            this.label.setIcon(bl3 ? this.leafIcon : this.folderIcon);
            this.setPreferredSize(new Dimension(1000, this.label.getPreferredSize().height));
            return this;
        }

        public void setLeafIcon(Icon icon) {
            this.leafIcon = icon;
        }

        public void setFolderIcon(Icon icon) {
            this.folderIcon = icon;
        }
    }
}

