/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree;

import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree.MTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mtree.MTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.query.MTreeQueryUtil;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import java.util.ArrayList;

public class MTreeIndex<O>
extends MTree<O>
implements RangeIndex<O>,
KNNIndex<O>,
DynamicIndex {
    private Relation<O> relation;
    protected DistanceQuery<O> distanceQuery;

    public MTreeIndex(Relation<O> relation, PageFile<MTreeNode<O>> pageFile, MTreeSettings<O, MTreeNode<O>, MTreeEntry> mTreeSettings) {
        super(pageFile, mTreeSettings);
        this.relation = relation;
        this.distanceQuery = this.getDistanceFunction().instantiate(relation);
    }

    @Override
    public double distance(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        if (dBIDRef == null || dBIDRef2 == null) {
            return Double.NaN;
        }
        if (DBIDUtil.equal(dBIDRef, dBIDRef2)) {
            return 0.0;
        }
        this.statistics.countDistanceCalculation();
        return this.distanceQuery.distance(dBIDRef, dBIDRef2);
    }

    @Override
    protected void initializeCapacities(MTreeEntry mTreeEntry) {
        int n = 8;
        int n2 = 0;
        if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(this.relation.getDataTypeInformation())) {
            Relation<O> relation = this.relation;
            n2 = 8 * RelationUtil.dimensionality(relation);
        }
        if (n2 <= 0) {
            this.getLogger().warning("Relation does not have a dimensionality -- simulating M-tree as external index!");
            n2 = 0;
        }
        double d = 12.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - d) / (4 + n2 + n + n) + 1;
        if (this.dirCapacity <= 2) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            this.getLogger().warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - d) / (4 + n2 + n) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            this.getLogger().warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
    }

    protected MTreeEntry createNewLeafEntry(DBID dBID, O o, double d) {
        return new MTreeLeafEntry(dBID, d);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.insertAll(this.relation.getDBIDs());
    }

    @Override
    public void insert(DBIDRef dBIDRef) {
        this.insert(this.createNewLeafEntry(DBIDUtil.deref(dBIDRef), this.relation.get(dBIDRef), Double.NaN), false);
    }

    @Override
    public void insertAll(DBIDs dBIDs) {
        ArrayList<MTreeEntry> arrayList = new ArrayList<MTreeEntry>(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDIter);
            O o = this.relation.get(dBID);
            arrayList.add(this.createNewLeafEntry(dBID, o, Double.NaN));
            dBIDIter.advance();
        }
        this.insertAll(arrayList);
    }

    @Override
    public final boolean delete(DBIDRef dBIDRef) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public void deleteAll(DBIDs dBIDs) {
        throw new NotImplementedException("Not yet supported.");
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery<O> distanceQuery2 = distanceFunction.instantiate(this.relation);
        return MTreeQueryUtil.getKNNQuery(this, distanceQuery2, objectArray);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            this.getLogger().debug("Distance function not supported by index - or 'equals' not implemented right!");
            return null;
        }
        DistanceQuery<O> distanceQuery2 = distanceFunction.instantiate(this.relation);
        return MTreeQueryUtil.getRangeQuery(this, distanceQuery2, new Object[0]);
    }

    @Override
    public String getLongName() {
        return "M-Tree";
    }

    @Override
    public String getShortName() {
        return "mtree";
    }
}

