/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split;

import de.lmu.ifi.dbs.elki.data.ModifiableHyperBoundingBox;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialUtil;
import de.lmu.ifi.dbs.elki.index.tree.spatial.rstarvariants.strategies.split.SplitStrategy;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.ArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@Reference(authors="Diane Greene", title="An implementation and performance analysis of spatial data access methods", booktitle="Proceedings of the Fifth International Conference on Data Engineering", url="http://dx.doi.org/10.1109/ICDE.1989.47268")
public class GreeneSplit
implements SplitStrategy {
    public static final GreeneSplit STATIC = new GreeneSplit();

    @Override
    public <E extends SpatialComparable, A> long[] split(A a, ArrayAdapter<E, A> arrayAdapter, int n) {
        double d;
        SpatialComparable spatialComparable;
        int n2;
        int n3 = arrayAdapter.size(a);
        int n4 = -1;
        double d2 = Double.NEGATIVE_INFINITY;
        int n5 = 0;
        int n6 = 0;
        double[] dArray = new double[n3];
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n2);
            dArray[n2] = SpatialUtil.volume(spatialComparable);
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n2);
            for (int i = n2 + 1; i < n3; ++i) {
                SpatialComparable spatialComparable2 = (SpatialComparable)arrayAdapter.get(a, i);
                d = SpatialUtil.volumeUnion(spatialComparable, spatialComparable2);
                double d3 = d - dArray[n2] - dArray[i];
                if (!(d3 > d2)) continue;
                d2 = d3;
                n5 = n2;
                n6 = i;
            }
        }
        if (d2 > 0.0) {
            SpatialComparable spatialComparable3 = (SpatialComparable)arrayAdapter.get(a, n5);
            spatialComparable = (SpatialComparable)arrayAdapter.get(a, n6);
            double d4 = Double.NEGATIVE_INFINITY;
            d = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < spatialComparable3.getDimensionality(); ++i) {
                double d5;
                double d6;
                double d7 = spatialComparable3.getMin(i) - spatialComparable.getMax(i);
                double d8 = Math.max(d7, d6 = spatialComparable.getMin(i) - spatialComparable3.getMax(i));
                double d9 = d8 / (d5 = Math.max(spatialComparable3.getMax(i), spatialComparable.getMax(i)) - Math.min(spatialComparable3.getMin(i), spatialComparable.getMin(i)));
                if (!(d9 > d4) && (d9 != d4 || !(d8 > d))) continue;
                d4 = d9;
                d = d8;
                n4 = i;
            }
        } else {
            n2 = n3 + 1 >> 1;
            return BitsUtil.ones(n2);
        }
        Object[] objectArray = new DoubleIntPair[n3];
        for (int i = 0; i < n3; ++i) {
            objectArray[i] = new DoubleIntPair(((SpatialComparable)arrayAdapter.get(a, i)).getMin(n4), i);
        }
        Arrays.sort(objectArray);
        long[] lArray = BitsUtil.zero(n3);
        n5 = n3 + 1 >> 1;
        for (n6 = 0; n6 < n5; ++n6) {
            BitsUtil.setI(lArray, ((DoubleIntPair)objectArray[n6]).second);
        }
        if (n3 % 2 == 0) {
            double d10;
            ModifiableHyperBoundingBox modifiableHyperBoundingBox = new ModifiableHyperBoundingBox((SpatialComparable)arrayAdapter.get(a, ((DoubleIntPair)objectArray[0]).second));
            for (int i = 1; i < n5; ++i) {
                modifiableHyperBoundingBox.extend((SpatialComparable)arrayAdapter.get(a, ((DoubleIntPair)objectArray[i]).second));
            }
            ModifiableHyperBoundingBox modifiableHyperBoundingBox2 = new ModifiableHyperBoundingBox((SpatialComparable)arrayAdapter.get(a, ((DoubleIntPair)objectArray[n3 - 1]).second));
            for (int i = n5 + 1; i < n3 - 1; ++i) {
                modifiableHyperBoundingBox2.extend((SpatialComparable)arrayAdapter.get(a, ((DoubleIntPair)objectArray[i]).second));
            }
            SpatialComparable spatialComparable4 = (SpatialComparable)arrayAdapter.get(a, ((DoubleIntPair)objectArray[n5]).second);
            double d11 = SpatialUtil.volumeUnion(modifiableHyperBoundingBox, spatialComparable4) - SpatialUtil.volume(modifiableHyperBoundingBox);
            if (d11 < (d10 = SpatialUtil.volumeUnion(modifiableHyperBoundingBox2, spatialComparable4) - SpatialUtil.volume(modifiableHyperBoundingBox2))) {
                BitsUtil.setI(lArray, ((DoubleIntPair)objectArray[n5]).second);
            }
        }
        return lArray;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GreeneSplit makeInstance() {
            return STATIC;
        }
    }
}

