/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.generate.metamodel;

import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.emc.emf.EmfMetaModel;
import org.eclipse.epsilon.emc.emf.EmfModel;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.etl.IEtlModule;
import org.eclipse.epsilon.hutn.exceptions.HutnGenerationException;
import org.eclipse.epsilon.hutn.generate.AbstractGenerator;
import org.eclipse.epsilon.hutn.model.hutn.HutnPackage;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.util.EpsilonUtil;

public class MetaModelGenerator
extends AbstractGenerator {
    private final IModel source;

    public MetaModelGenerator(Spec spec) {
        this.source = new InMemoryEmfModel("Intermediate", spec.eResource(), HutnPackage.eINSTANCE);
    }

    @Override
    protected EmfModel generate(Resource resource) throws HutnGenerationException {
        try {
            InMemoryEmfModel target = new InMemoryEmfModel("MetaModel", resource, EcorePackage.eINSTANCE);
            IEtlModule transformer = EpsilonUtil.initialiseEtlModule(this.source, target, new EmfMetaModel("Ecore", "http://www.eclipse.org/emf/2002/Ecore"));
            transformer.parse(MetaModelGenerator.class.getResource("Intermediate2MetaModel.etl").toURI());
            transformer.execute();
            return target;
        }
        catch (Exception e) {
            throw new HutnGenerationException(e);
        }
    }
}

