/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.AbstractKMeans;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMeansInitialization;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.model.KMeansModel;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.StringStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Reference(authors="C. Elkan", title="Using the triangle inequality to accelerate k-means", booktitle="Proc. 20th International Conference on Machine Learning, ICML 2003", url="http://www.aaai.org/Library/ICML/2003/icml03-022.php")
public class KMeansElkan<V extends NumberVector>
extends AbstractKMeans<V, KMeansModel> {
    private static final Logging LOG = Logging.getLogger(KMeansElkan.class);
    private static final String KEY = KMeansElkan.class.getName();
    private boolean varstat = false;

    public KMeansElkan(NumberVectorDistanceFunction<? super V> numberVectorDistanceFunction, int n, int n2, KMeansInitialization<? super V> kMeansInitialization, boolean bl) {
        super(numberVectorDistanceFunction, n, n2, kMeansInitialization);
        this.varstat = bl;
    }

    @Override
    public Clustering<KMeansModel> run(Database database, Relation<V> relation) {
        int n;
        if (relation.size() <= 0) {
            return new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new StringStatistic(KEY + ".initialization", this.initializer.toString()));
        }
        List<Vector> list = this.initializer.chooseInitialMeans(database, relation, this.k, this.getDistanceFunction(), Vector.FACTORY);
        ArrayList<ModifiableDBIDs> arrayList = new ArrayList<ModifiableDBIDs>();
        for (int i = 0; i < this.k; ++i) {
            arrayList.add(DBIDUtil.newHashSet((int)((double)relation.size() * 2.0 / (double)this.k)));
        }
        WritableIntegerDataStore writableIntegerDataStore = DataStoreUtil.makeIntegerStorage(relation.getDBIDs(), 3, -1);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 3, Double.POSITIVE_INFINITY);
        WritableDataStore<double[]> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, double[].class);
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            writableDataStore.put(dBIDIter, new double[this.k]);
            dBIDIter.advance();
        }
        int n2 = list.get(0).getDimensionality();
        ArrayList<Vector> arrayList2 = new ArrayList<Vector>(this.k);
        for (int i = 0; i < this.k; ++i) {
            arrayList2.add(new Vector(n2));
        }
        double[] dArray = new double[this.k];
        double[][] dArray2 = new double[this.k][this.k];
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("K-Means iteration", LOG) : null;
        LongStatistic longStatistic = LOG.isStatistics() ? new LongStatistic(this.getClass().getName() + ".reassignments") : null;
        for (n = 0; this.maxiter <= 0 || n < this.maxiter; ++n) {
            int n3;
            int n4;
            int n5;
            LOG.incrementProcessed(indefiniteProgress);
            if (n == 0) {
                n5 = this.initialAssignToNearestCluster(relation, list, arrayList2, arrayList, writableIntegerDataStore, writableDoubleDataStore, writableDataStore);
            } else {
                this.recomputeSeperation(list, dArray, dArray2);
                n5 = this.assignToNearestCluster(relation, list, arrayList2, arrayList, writableIntegerDataStore, dArray, dArray2, writableDoubleDataStore, writableDataStore);
            }
            if (longStatistic != null) {
                longStatistic.setLong(n5);
                LOG.statistics(longStatistic);
            }
            if (n5 == 0) break;
            for (n4 = 0; n4 < this.k; ++n4) {
                n3 = ((ModifiableDBIDs)arrayList.get(n4)).size();
                ((Vector)arrayList2.get(n4)).timesEquals(n3 > 0 ? 1.0 / (double)n3 : 1.0);
            }
            this.maxMoved(list, arrayList2, dArray);
            this.updateBounds(relation, writableIntegerDataStore, writableDoubleDataStore, writableDataStore, dArray);
            for (n4 = 0; n4 < this.k; ++n4) {
                n3 = ((ModifiableDBIDs)arrayList.get(n4)).size();
                list.get(n4).set((Vector)arrayList2.get(n4));
                ((Vector)arrayList2.get(n4)).timesEquals(n3 > 0 ? (double)n3 : 1.0);
            }
        }
        LOG.setCompleted(indefiniteProgress);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(KEY + ".iterations", n));
        }
        writableDoubleDataStore.destroy();
        writableDataStore.destroy();
        double d = 0.0;
        Clustering<KMeansModel> clustering = new Clustering<KMeansModel>("k-Means Clustering", "kmeans-clustering");
        for (int i = 0; i < arrayList.size(); ++i) {
            DBIDs dBIDs = (DBIDs)arrayList.get(i);
            if (dBIDs.size() == 0) continue;
            double d2 = 0.0;
            Vector vector = list.get(i);
            Object object = dBIDs.iter();
            while (object.valid()) {
                d2 += this.distanceFunction.distance(vector, (NumberVector)relation.get((DBIDRef)object));
                object.advance();
            }
            d += d2;
            object = new KMeansModel(vector, d2);
            clustering.addToplevelCluster(new Cluster<Object>(dBIDs, object));
        }
        if (LOG.isStatistics() && this.varstat) {
            LOG.statistics(new DoubleStatistic(this.getClass().getName() + ".variance-sum", d));
        }
        return clustering;
    }

    private void recomputeSeperation(List<Vector> list, double[] dArray, double[][] dArray2) {
        int n = list.size();
        assert (dArray.length == n);
        boolean bl = this.distanceFunction instanceof SquaredEuclideanDistanceFunction;
        Arrays.fill(dArray, Double.POSITIVE_INFINITY);
        for (int i = 1; i < n; ++i) {
            Vector vector = list.get(i);
            for (int j = 0; j < i; ++j) {
                double d = this.distanceFunction.distance(vector, list.get(j));
                d = bl ? Math.sqrt(d) : d;
                dArray2[i][j] = d *= 0.5;
                dArray2[j][i] = d;
                dArray[i] = d < dArray[i] ? d : dArray[i];
                dArray[j] = d < dArray[j] ? d : dArray[j];
            }
        }
    }

    private int initialAssignToNearestCluster(Relation<V> relation, List<Vector> list, List<Vector> list2, List<ModifiableDBIDs> list3, WritableIntegerDataStore writableIntegerDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDataStore<double[]> writableDataStore) {
        assert (this.k == list.size());
        DistanceFunction distanceFunction = this.getDistanceFunction();
        boolean bl = distanceFunction instanceof SquaredEuclideanDistanceFunction;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
            double[] dArray = (double[])writableDataStore.get(dBIDIter);
            double d = Double.POSITIVE_INFINITY;
            int n = -1;
            for (int i = 0; i < this.k; ++i) {
                double d2 = distanceFunction.distance(numberVector, list.get(i));
                dArray[i] = d2 = bl ? Math.sqrt(d2) : d2;
                if (!(d2 < d)) continue;
                n = i;
                d = d2;
            }
            ModifiableDBIDs modifiableDBIDs = list3.get(n);
            modifiableDBIDs.add(dBIDIter);
            writableIntegerDataStore.putInt(dBIDIter, n);
            writableDoubleDataStore.putDouble(dBIDIter, d);
            double[] dArray2 = list2.get(n).getArrayRef();
            for (int i = 0; i < numberVector.getDimensionality(); ++i) {
                int n2 = i;
                dArray2[n2] = dArray2[n2] + numberVector.doubleValue(i);
            }
            dBIDIter.advance();
        }
        return relation.size();
    }

    private int assignToNearestCluster(Relation<V> relation, List<Vector> list, List<Vector> list2, List<ModifiableDBIDs> list3, WritableIntegerDataStore writableIntegerDataStore, double[] dArray, double[][] dArray2, WritableDoubleDataStore writableDoubleDataStore, WritableDataStore<double[]> writableDataStore) {
        assert (this.k == list.size());
        DistanceFunction distanceFunction = this.getDistanceFunction();
        boolean bl = distanceFunction instanceof SquaredEuclideanDistanceFunction;
        int n = 0;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            int n2 = writableIntegerDataStore.intValue(dBIDIter);
            double d = writableDoubleDataStore.doubleValue(dBIDIter);
            if (!(d <= dArray[n2])) {
                boolean bl2 = true;
                NumberVector numberVector = (NumberVector)relation.get(dBIDIter);
                double[] dArray3 = (double[])writableDataStore.get(dBIDIter);
                int n3 = n2;
                for (int i = 0; i < this.k; ++i) {
                    if (n2 == i || d <= dArray3[i] || d <= dArray2[n3][i]) continue;
                    if (bl2) {
                        d = distanceFunction.distance(numberVector, list.get(n3));
                        d = bl ? Math.sqrt(d) : d;
                        writableDoubleDataStore.putDouble(dBIDIter, d);
                        bl2 = false;
                        if (d <= dArray3[i] || d <= dArray2[n3][i]) continue;
                    }
                    double d2 = distanceFunction.distance(numberVector, list.get(i));
                    dArray3[i] = d2 = bl ? Math.sqrt(d2) : d2;
                    if (!(d2 < d)) continue;
                    n3 = i;
                    d = d2;
                }
                if (n3 != n2) {
                    writableDoubleDataStore.putDouble(dBIDIter, d);
                    ModifiableDBIDs modifiableDBIDs = list3.get(n3);
                    modifiableDBIDs.add(dBIDIter);
                    writableIntegerDataStore.putInt(dBIDIter, n3);
                    double[] dArray4 = list2.get(n3).getArrayRef();
                    ModifiableDBIDs modifiableDBIDs2 = list3.get(n2);
                    modifiableDBIDs2.remove(dBIDIter);
                    double[] dArray5 = list2.get(n2).getArrayRef();
                    int n4 = 0;
                    while (n4 < numberVector.getDimensionality()) {
                        double d3 = numberVector.doubleValue(n4);
                        int n5 = n4;
                        dArray4[n5] = dArray4[n5] + d3;
                        int n6 = n4++;
                        dArray5[n6] = dArray5[n6] - d3;
                    }
                    ++n;
                }
            }
            dBIDIter.advance();
        }
        return n;
    }

    private double maxMoved(List<Vector> list, List<Vector> list2, double[] dArray) {
        assert (list.size() == this.k);
        assert (list2.size() == this.k);
        assert (dArray.length == this.k);
        boolean bl = this.distanceFunction instanceof SquaredEuclideanDistanceFunction;
        double d = 0.0;
        for (int i = 0; i < this.k; ++i) {
            double d2 = this.distanceFunction.distance(list.get(i), list2.get(i));
            dArray[i] = d2 = bl ? Math.sqrt(d2) : d2;
            d = d2 > d ? d2 : d;
        }
        return d;
    }

    private void updateBounds(Relation<V> relation, WritableIntegerDataStore writableIntegerDataStore, WritableDoubleDataStore writableDoubleDataStore, WritableDataStore<double[]> writableDataStore, double[] dArray) {
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            writableDoubleDataStore.increment(dBIDIter, dArray[writableIntegerDataStore.intValue(dBIDIter)]);
            double[] dArray2 = (double[])writableDataStore.get(dBIDIter);
            for (int i = 0; i < this.k; ++i) {
                int n = i;
                dArray2[n] = dArray2[n] - dArray[i];
            }
            dBIDIter.advance();
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractKMeans.Parameterizer<V> {
        public static final OptionID VARSTAT_ID = new OptionID("kmeans.varstat", "Compute the final clustering variance statistic. Needs an additional full pass over the data set.");
        protected boolean varstat = false;

        @Override
        protected Logging getLogger() {
            return LOG;
        }

        @Override
        protected void getParameterDistanceFunction(Parameterization parameterization) {
            super.getParameterDistanceFunction(parameterization);
            if (this.distanceFunction instanceof SquaredEuclideanDistanceFunction) {
                return;
            }
            if (this.distanceFunction != null && !this.distanceFunction.isMetric()) {
                LOG.warning("Elkan k-means requires a metric distance, and k-means should only be used with squared Euclidean distance!");
            }
        }

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            Flag flag = new Flag(VARSTAT_ID);
            if (parameterization.grab(flag)) {
                this.varstat = flag.isTrue();
            }
        }

        @Override
        protected KMeansElkan<V> makeInstance() {
            return new KMeansElkan(this.distanceFunction, this.k, this.maxiter, this.initializer, this.varstat);
        }
    }
}

