/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class ProxyView<O>
extends AbstractRelation<O> {
    private static final Logging LOG = Logging.getLogger(ProxyView.class);
    private DBIDs idview;
    private final Relation<O> inner;

    public ProxyView(DBIDs dBIDs, Relation<O> relation) {
        this.idview = DBIDUtil.makeUnmodifiable(dBIDs);
        this.inner = relation;
    }

    @Override
    public O get(DBIDRef dBIDRef) {
        assert (this.idview.contains(dBIDRef)) : "Accessing object not included in view.";
        return this.inner.get(dBIDRef);
    }

    @Override
    public DBIDs getDBIDs() {
        return this.idview;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.idview.iter();
    }

    @Override
    public int size() {
        return this.idview.size();
    }

    @Override
    public SimpleTypeInformation<O> getDataTypeInformation() {
        return this.inner.getDataTypeInformation();
    }

    @Override
    public String getLongName() {
        return "Partition of " + this.inner.getLongName();
    }

    @Override
    public String getShortName() {
        return "partition";
    }

    public void setDBIDs(DBIDs dBIDs) {
        this.idview = dBIDs;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

