/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.distance.distancefunction.probabilistic;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.distance.distancefunction.AbstractNumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="D. M. Endres, J. E. Schindelin", title="A new metric for probability distributions", booktitle="IEEE Transactions on Information Theory, 49(7)", url="http://dx.doi.org/10.1109/TIT.2003.813506")
public class SqrtJensenShannonDivergenceDistanceFunction
extends AbstractNumberVectorDistanceFunction {
    public static final SqrtJensenShannonDivergenceDistanceFunction STATIC = new SqrtJensenShannonDivergenceDistanceFunction();

    @Deprecated
    public SqrtJensenShannonDivergenceDistanceFunction() {
    }

    @Override
    public double distance(NumberVector numberVector, NumberVector numberVector2) {
        int n = SqrtJensenShannonDivergenceDistanceFunction.dimensionality(numberVector, numberVector2);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3;
            double d4 = numberVector.doubleValue(i);
            if (d4 == (d3 = numberVector2.doubleValue(i)) || !((d2 = 0.5 * (d4 + d3)) > 0.0) && !(d2 < 0.0)) continue;
            if (d4 > 0.0) {
                d += d4 * Math.log(d4 / d2);
            }
            if (!(d3 > 0.0)) continue;
            d += d3 * Math.log(d3 / d2);
        }
        return Math.sqrt(d);
    }

    @Override
    public boolean isMetric() {
        return true;
    }

    public String toString() {
        return "SqrtJensenShannonDivergenceDistance";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (this.getClass().equals(object.getClass())) {
            return true;
        }
        return super.equals(object);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected SqrtJensenShannonDivergenceDistanceFunction makeInstance() {
            return STATIC;
        }
    }
}

