/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.index.tree.Entry;
import java.util.ArrayList;

public class IndexTreePath<E extends Entry> {
    private IndexTreePath<E> parentPath;
    private final E entry;
    private final int index;

    public IndexTreePath(IndexTreePath<E> indexTreePath, E e, int n) {
        if (e == null) {
            throw new IllegalArgumentException("entry in TreePath must be non null.");
        }
        this.entry = e;
        this.index = n;
        this.parentPath = indexTreePath;
    }

    public E getEntry() {
        return this.entry;
    }

    public int getIndex() {
        return this.index;
    }

    public int getPathCount() {
        int n = 0;
        IndexTreePath<E> indexTreePath = this;
        while (indexTreePath != null) {
            ++n;
            indexTreePath = indexTreePath.parentPath;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IndexTreePath<E> indexTreePath = (IndexTreePath<E>)object;
        IndexTreePath<E> indexTreePath2 = this;
        while (indexTreePath2 != null) {
            if (indexTreePath == null || indexTreePath2.index != indexTreePath.index || !indexTreePath2.entry.equals(indexTreePath.entry)) {
                return false;
            }
            indexTreePath = indexTreePath.parentPath;
            indexTreePath2 = indexTreePath2.parentPath;
        }
        return true;
    }

    public IndexTreePath<E> getParentPath() {
        return this.parentPath;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (IndexTreePath<E> indexTreePath = this; indexTreePath != null; indexTreePath = indexTreePath.getParentPath()) {
            arrayList.add("@" + this.index + ":" + this.entry.toString());
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            stringBuilder.append((String)arrayList.get(i));
            if (i <= 0) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

