/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.linearalgebra.pca;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.CovarianceMatrixBuilder;

public abstract class AbstractCovarianceMatrixBuilder
implements CovarianceMatrixBuilder {
    @Override
    public Matrix processDatabase(Relation<? extends NumberVector> relation) {
        return this.processIds(relation.getDBIDs(), relation);
    }

    @Override
    public abstract Matrix processIds(DBIDs var1, Relation<? extends NumberVector> var2);

    @Override
    public Matrix processQueryResults(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation, int n) {
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
        for (int i = 0; doubleDBIDListIter.valid() && i < n; ++i) {
            arrayModifiableDBIDs.add(doubleDBIDListIter);
            doubleDBIDListIter.advance();
        }
        return this.processIds(arrayModifiableDBIDs, relation);
    }

    @Override
    public final Matrix processQueryResults(DoubleDBIDList doubleDBIDList, Relation<? extends NumberVector> relation) {
        return this.processQueryResults(doubleDBIDList, relation, doubleDBIDList.size());
    }
}

