/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.RayleighDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

public class RayleighLMMEstimator
extends AbstractLMMEstimator<RayleighDistribution> {
    public static final RayleighLMMEstimator STATIC = new RayleighLMMEstimator();

    private RayleighLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 2;
    }

    @Override
    public RayleighDistribution estimateFromLMoments(double[] dArray) {
        double d = 2.0 * dArray[1] / (MathUtil.SQRTPI * (MathUtil.SQRT2 - 1.0));
        double d2 = dArray[0] - d * MathUtil.SQRTHALFPI;
        return new RayleighDistribution(d2, d);
    }

    @Override
    public Class<? super RayleighDistribution> getDistributionClass() {
        return RayleighDistribution.class;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected RayleighLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

