/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.IntegerObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class IntegerObjectMinHeap<V>
implements IntegerObjectHeap<V> {
    protected int[] twoheap;
    protected Object[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public IntegerObjectMinHeap() {
        int[] nArray = new int[31];
        Object[] objectArray = new Object[31];
        this.twoheap = nArray;
        this.twovals = objectArray;
    }

    public IntegerObjectMinHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        int[] nArray = new int[n2];
        Object[] objectArray = new Object[n2];
        this.twoheap = nArray;
        this.twovals = objectArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0);
        Arrays.fill(this.twovals, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(int n, V v) {
        int n2 = n;
        V v2 = v;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
            this.twovals = Arrays.copyOf(this.twovals, this.twovals.length + this.twovals.length + 1);
        }
        int n3 = this.size++;
        this.twoheap[n3] = n2;
        this.twovals[n3] = v2;
        this.heapifyUp(n3, n2, v2);
    }

    @Override
    public void add(int n, V v, int n2) {
        if (this.size < n2) {
            this.add(n, v);
        } else if (this.twoheap[0] < n) {
            this.replaceTopElement(n, v);
        }
    }

    @Override
    public void replaceTopElement(int n, V v) {
        this.heapifyDown(n, v);
    }

    private void heapifyUp(int n, int n2, Object object) {
        int n3;
        int n4;
        while (n > 0 && n2 < (n4 = this.twoheap[n3 = n - 1 >>> 1])) {
            this.twoheap[n] = n4;
            this.twovals[n] = this.twovals[n3];
            n = n3;
        }
        this.twoheap[n] = n2;
        this.twovals[n] = object;
    }

    @Override
    public void poll() {
        --this.size;
        if (this.size > 0) {
            int n = this.twoheap[this.size];
            Object object = this.twovals[this.size];
            this.twoheap[this.size] = 0;
            this.twovals[this.size] = null;
            this.heapifyDown(n, object);
        } else {
            this.twoheap[0] = 0;
            this.twovals[0] = null;
        }
    }

    private void heapifyDown(int n, Object object) {
        int n2 = this.size >>> 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 << 1) + 1;
            int n5 = this.twoheap[n4];
            int n6 = n4 + 1;
            if (n6 < this.size && n5 > this.twoheap[n6]) {
                n4 = n6;
                n5 = this.twoheap[n6];
            }
            if (n <= n5) break;
            this.twoheap[n3] = n5;
            this.twovals[n3] = this.twovals[n4];
            n3 = n4;
        }
        this.twoheap[n3] = n;
        this.twovals[n3] = object;
    }

    @Override
    public int peekKey() {
        return this.twoheap[0];
    }

    @Override
    public V peekValue() {
        return (V)this.twovals[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(IntegerObjectMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.getKey()).append(':').append(unsortedIter.getValue()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements IntegerObjectHeap.UnsortedIter<V> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < IntegerObjectMinHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getKey() {
            return IntegerObjectMinHeap.this.twoheap[this.pos];
        }

        @Override
        public V getValue() {
            return IntegerObjectMinHeap.this.twovals[this.pos];
        }
    }
}

