/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.histogram;

import de.lmu.ifi.dbs.elki.math.scales.LinearScale;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.histogram.AbstractObjStaticHistogram;

public abstract class AbstractObjDynamicHistogram<T>
extends AbstractObjStaticHistogram<T> {
    private double[] cacheposs;
    private Object[] cachevals;
    private int cachefill;
    private int destsize;

    public AbstractObjDynamicHistogram(int n) {
        super(-1, 0.0, 1.0);
        this.destsize = n;
        this.cacheposs = new double[this.destsize << 1];
        this.cachevals = new Object[this.destsize << 1];
        this.cachefill = 0;
    }

    void materialize() {
        int n;
        if (this.cachefill <= 0) {
            return;
        }
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < this.cachefill; ++i) {
            d = Math.min(d, this.cacheposs[i]);
            d2 = Math.max(d2, this.cacheposs[i]);
        }
        LinearScale linearScale = new LinearScale(d, d2);
        d = linearScale.getMin();
        d2 = linearScale.getMax();
        this.base = d;
        this.max = d2;
        this.binsize = (d2 - d) / (double)this.destsize;
        this.data = new Object[this.destsize << 1];
        for (n = 0; n < this.destsize; ++n) {
            this.data[n] = this.makeObject();
        }
        this.size = this.destsize;
        n = this.cachefill;
        this.cachefill = -1;
        for (int i = 0; i < n; ++i) {
            this.putData(this.cacheposs[i], this.cachevals[i]);
        }
        this.cacheposs = null;
        this.cachevals = null;
    }

    @Override
    public T get(double d) {
        this.materialize();
        this.testResample(d);
        Object t = super.get(d);
        return t;
    }

    @Override
    public void putData(double d, T t) {
        if (this.cachefill >= 0 && this.cachefill < this.cacheposs.length) {
            this.cacheposs[this.cachefill] = d;
            this.cachevals[this.cachefill] = this.cloneForCache(t);
            ++this.cachefill;
            return;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            this.aggregateSpecial(t, 0);
        } else if (d == Double.POSITIVE_INFINITY) {
            this.aggregateSpecial(t, 1);
        } else if (Double.isNaN(d)) {
            this.aggregateSpecial(t, 2);
        } else {
            T t2 = this.get(d);
            this.data[this.getBinNr((double)d)] = this.aggregate(t2, t);
        }
    }

    protected void aggregateSpecial(T t, int n) {
        Object t2 = this.getSpecial(n);
        this.special[n] = this.aggregate(t2, t);
    }

    private void testResample(double d) {
        int n;
        int n2;
        int n3 = this.getBinNr(d);
        if (n3 < 0) {
            n2 = this.size - n3;
            n = -n3;
        } else if (n3 >= this.data.length) {
            n2 = n3 + 1;
            n = 0;
        } else {
            return;
        }
        if (n2 < this.data.length) {
            return;
        }
        int n4 = BitsUtil.magnitude(n2 / this.destsize) - 1;
        assert (n4 > 0) : "No resampling required?!?";
        int n5 = 1 << n4;
        int n6 = n / (n5 - 1);
        int n7 = n6 >= 0 ? n6 : 0;
        int n8 = (n7 << n4) - n;
        assert (-n5 < n8 && n8 <= n7 && n7 < n8 + n5) : n8 + " -> " + n7 + " s=" + n5 + " o=" + n + " l=" + n4;
        while (n8 < this.size) {
            assert (n7 < n8 + n5 && n7 < this.data.length);
            this.data[n7] = this.downsample(this.data, Math.max(0, n8), Math.min(this.size, n8 + n5), n5);
            n8 += n5;
            ++n7;
        }
        while (n7 < this.data.length) {
            this.data[n7] = null;
            ++n7;
        }
        if (n >= n5) {
            n7 = n6 - 1 < this.size ? n6 - 1 : this.size - 1;
            n8 = (n7 << n4) - n;
            assert (n7 > n8) : n8 + " -> " + n7 + " s=" + n5 + " o=" + n + " l=" + n4;
            while (n8 > -n5) {
                assert (n7 >= n8 && n7 >= 0);
                this.data[n7] = this.downsample(this.data, Math.max(0, n8), Math.min(this.size, n8 + n5), n5);
                n8 -= n5;
                --n7;
            }
            while (n7 >= 0) {
                this.data[n7] = this.makeObject();
                --n7;
            }
        }
        this.base -= (double)(this.offset + n) * this.binsize;
        this.offset = 0;
        this.size = this.size + 1 >> n4;
        this.binsize *= (double)(1 << n4);
        this.max = this.base + this.binsize * (double)this.size;
    }

    @Override
    public AbstractObjStaticHistogram.Iter iter() {
        this.materialize();
        return super.iter();
    }

    @Override
    public int getNumBins() {
        this.materialize();
        return super.getNumBins();
    }

    @Override
    public double getBinsize() {
        this.materialize();
        return super.getBinsize();
    }

    @Override
    public double getCoverMinimum() {
        this.materialize();
        return super.getCoverMinimum();
    }

    @Override
    public double getCoverMaximum() {
        this.materialize();
        return super.getCoverMaximum();
    }

    protected abstract T downsample(Object[] var1, int var2, int var3, int var4);

    protected abstract T aggregate(T var1, T var2);

    protected abstract T cloneForCache(T var1);
}

