/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers;

import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.visualizers.VisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.thumbs.ThumbnailVisualization;

public abstract class AbstractVisFactory
implements VisFactory {
    protected AbstractVisFactory() {
    }

    @Override
    public Visualization makeVisualizationOrThumbnail(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection, int n) {
        if (d <= 0.0 || d2 <= 0.0) {
            LoggingUtil.warning("Cannot generate visualization of 0 size.", new Throwable());
            return null;
        }
        if (this.allowThumbnails(visualizationTask)) {
            return new ThumbnailVisualization(this, visualizationTask, visualizationPlot, d, d2, projection, n);
        }
        return this.makeVisualization(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public abstract Visualization makeVisualization(VisualizationTask var1, VisualizationPlot var2, double var3, double var5, Projection var7);

    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return true;
    }
}

