/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayStaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.util.Arrays;

class ArrayStaticIntegerDBIDs
implements IntegerArrayStaticDBIDs {
    protected int[] store;

    protected ArrayStaticIntegerDBIDs(int ... nArray) {
        this.store = nArray;
    }

    @Override
    public int size() {
        return this.store.length;
    }

    @Override
    public boolean isEmpty() {
        return this.store.length == 0;
    }

    @Override
    public boolean contains(DBIDRef dBIDRef) {
        int n = DBIDUtil.asInteger(dBIDRef);
        for (int i = 0; i < this.store.length; ++i) {
            if (this.store[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public DBID get(int n) {
        return DBIDFactory.FACTORY.importInteger(this.store[n]);
    }

    @Override
    public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
        if (dBIDVar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)dBIDVar).internalSetIndex(this.store[n]);
            return dBIDVar;
        }
        dBIDVar.set(this.get(n));
        return dBIDVar;
    }

    @Override
    public int binarySearch(DBIDRef dBIDRef) {
        return Arrays.binarySearch(this.store, DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public Slice slice(int n, int n2) {
        return new Slice(n, n2);
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int n, int n2) {
            this.begin = n;
            this.end = n2;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef dBIDRef) {
            int n = dBIDRef.internalGetIndex();
            for (int i = this.begin; i < this.end; ++i) {
                if (ArrayStaticIntegerDBIDs.this.store[i] != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int n) {
            return ArrayStaticIntegerDBIDs.this.get(this.begin + n);
        }

        @Override
        public DBIDVar assignVar(int n, DBIDVar dBIDVar) {
            return ArrayStaticIntegerDBIDs.this.assignVar(this.begin + n, dBIDVar);
        }

        @Override
        public int binarySearch(DBIDRef dBIDRef) {
            return Arrays.binarySearch(ArrayStaticIntegerDBIDs.this.store, this.begin, this.end, dBIDRef.internalGetIndex()) - this.begin;
        }

        @Override
        public SliceItr iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int n, int n2) {
            return new Slice(n + n, n + n2);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                return ArrayStaticIntegerDBIDs.this.store[this.pos];
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int n) {
                this.pos += n;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int n) {
                this.pos = Slice.this.begin + n;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    protected class Itr
    implements IntegerDBIDArrayIter {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < ArrayStaticIntegerDBIDs.this.store.length && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int n) {
            this.pos += 0;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int n) {
            this.pos = n;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return ArrayStaticIntegerDBIDs.this.store[this.pos];
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(object);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
        }
    }
}

