/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.filter.typeconversions;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.uncertain.UnweightedDiscreteUncertainObject;
import de.lmu.ifi.dbs.elki.datasource.filter.AbstractConversionFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;

public class UncertainSplitFilter
extends AbstractConversionFilter<NumberVector, UnweightedDiscreteUncertainObject> {
    private static final Logging LOG = Logging.getLogger(UncertainSplitFilter.class);
    private int dims;

    public UncertainSplitFilter(int n) {
        this.dims = n;
    }

    @Override
    protected UnweightedDiscreteUncertainObject filterSingleObject(NumberVector numberVector) {
        int n = numberVector.getDimensionality();
        if (n % this.dims != 0) {
            throw new AbortException("Vector length " + n + " not divisible by the number of dimensions " + this.dims);
        }
        int n2 = n / this.dims;
        DoubleVector[] doubleVectorArray = new DoubleVector[n2];
        double[] dArray = new double[this.dims];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            dArray[n3++] = numberVector.doubleValue(i);
            if (n3 != this.dims) continue;
            doubleVectorArray[n4++] = new DoubleVector(dArray);
            n3 = 0;
        }
        return new UnweightedDiscreteUncertainObject(doubleVectorArray);
    }

    @Override
    protected SimpleTypeInformation<? super NumberVector> getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    protected SimpleTypeInformation<UnweightedDiscreteUncertainObject> convertedType(SimpleTypeInformation<NumberVector> simpleTypeInformation) {
        int n = ((VectorFieldTypeInformation)simpleTypeInformation).getDimensionality();
        if (n % this.dims != 0) {
            throw new AbortException("Vector length " + n + " not divisible by the number of dimensions " + this.dims);
        }
        return new VectorFieldTypeInformation<UnweightedDiscreteUncertainObject>(UnweightedDiscreteUncertainObject.FACTORY, n);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID DIM_ID = new OptionID("uncertain.dimensionality", "Dimensionality of the data set (used for splitting).");
        protected int dims;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            IntParameter intParameter = (IntParameter)new IntParameter(DIM_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
            if (parameterization.grab(intParameter)) {
                this.dims = intParameter.intValue();
            }
        }

        @Override
        protected UncertainSplitFilter makeInstance() {
            return new UncertainSplitFilter(this.dims);
        }
    }
}

