/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.projected;

import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedRelation;
import de.lmu.ifi.dbs.elki.database.relation.ProjectedView;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Counter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public class ProjectedIndex<O, I>
implements KNNIndex<O>,
RKNNIndex<O>,
RangeIndex<O> {
    private static final Logging LOG = Logging.getLogger(ProjectedIndex.class);
    Index inner;
    Projection<O, I> proj;
    Relation<O> relation;
    Relation<I> view;
    boolean norefine;
    double kmulti = 1.0;
    final Counter refinements;

    public ProjectedIndex(Relation<O> relation, Projection<O, I> projection, Relation<I> relation2, Index index, boolean bl, double d) {
        this.relation = relation;
        this.view = relation2;
        this.inner = index;
        this.proj = projection;
        this.norefine = bl;
        this.kmulti = d;
        this.refinements = LOG.isStatistics() ? LOG.newCounter(this.getClass().getName() + ".refinements") : null;
    }

    private void countRefinement() {
        if (this.refinements != null) {
            this.refinements.increment();
        }
    }

    @Override
    public void initialize() {
        this.inner.initialize();
    }

    @Override
    public String getLongName() {
        return "projected " + this.inner.getLongName();
    }

    @Override
    public String getShortName() {
        return "proj-" + this.inner.getShortName();
    }

    @Override
    public void logStatistics() {
        if (this.refinements != null) {
            LOG.statistics(this.refinements);
        }
        this.inner.logStatistics();
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof KNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery<I> distanceQuery2 = distanceQuery.getDistanceFunction().instantiate(this.view);
        KNNQuery<I> kNNQuery = ((KNNIndex)this.inner).getKNNQuery(distanceQuery2, objectArray);
        if (kNNQuery == null) {
            return null;
        }
        return new ProjectedKNNQuery(distanceQuery, kNNQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof RangeIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery<I> distanceQuery2 = distanceQuery.getDistanceFunction().instantiate(this.view);
        RangeQuery<I> rangeQuery = ((RangeIndex)this.inner).getRangeQuery(distanceQuery2, objectArray);
        if (rangeQuery == null) {
            return null;
        }
        return new ProjectedRangeQuery(distanceQuery, rangeQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (!(this.inner instanceof RKNNIndex)) {
            return null;
        }
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        for (Object object : objectArray) {
            if (object != "exact") continue;
            return null;
        }
        DistanceQuery<I> distanceQuery2 = distanceQuery.getDistanceFunction().instantiate(this.view);
        RKNNQuery<I> rKNNQuery = ((RKNNIndex)this.inner).getRKNNQuery(distanceQuery2, objectArray);
        if (rKNNQuery == null) {
            return null;
        }
        return new ProjectedRKNNQuery(distanceQuery, rKNNQuery);
    }

    public static class Factory<O, I>
    implements IndexFactory<O, ProjectedIndex<O, I>> {
        Projection<O, I> proj;
        IndexFactory<I, ?> inner;
        boolean materialize = false;
        boolean norefine = false;
        double kmulti = 1.0;

        public Factory(Projection<O, I> projection, IndexFactory<I, ?> indexFactory, boolean bl, boolean bl2, double d) {
            this.proj = projection;
            this.inner = indexFactory;
            this.materialize = bl;
            this.kmulti = d;
        }

        @Override
        public ProjectedIndex<O, I> instantiate(Relation<O> relation) {
            if (!this.proj.getInputDataTypeInformation().isAssignableFromType(relation.getDataTypeInformation())) {
                return null;
            }
            this.proj.initialize(relation.getDataTypeInformation());
            Index index = null;
            AbstractRelation abstractRelation = null;
            if (this.materialize) {
                DBIDs dBIDs = relation.getDBIDs();
                WritableDataStore<I> writableDataStore = DataStoreUtil.makeStorage(dBIDs, 30, this.proj.getOutputDataTypeInformation().getRestrictionClass());
                DBIDIter dBIDIter = dBIDs.iter();
                while (dBIDIter.valid()) {
                    writableDataStore.put(dBIDIter, this.proj.project(relation.get(dBIDIter)));
                    dBIDIter.advance();
                }
                abstractRelation = new MaterializedRelation<I>("Projected Index", "projected-index", this.proj.getOutputDataTypeInformation(), writableDataStore, dBIDs);
            } else {
                abstractRelation = new ProjectedView<O, I>(relation, this.proj);
            }
            index = (Index)this.inner.instantiate(abstractRelation);
            if (index == null) {
                return null;
            }
            return new ProjectedIndex<O, I>(relation, this.proj, abstractRelation, index, this.norefine, this.kmulti);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.proj.getInputDataTypeInformation();
        }

        public static class Parameterizer<O, I>
        extends AbstractParameterizer {
            public static final OptionID PROJ_ID = new OptionID("projindex.proj", "Projection to use for the projected index.");
            public static final OptionID INDEX_ID = new OptionID("projindex.inner", "Index to use on the projected data.");
            public static final OptionID MATERIALIZE_FLAG = new OptionID("projindex.materialize", "Flag to materialize the projected data.");
            public static final OptionID DISABLE_REFINE_FLAG = new OptionID("projindex.disable-refine", "Flag to disable refinement of distances.");
            public static final OptionID K_MULTIPLIER_ID = new OptionID("projindex.kmulti", "Multiplier for k.");
            Projection<O, I> proj;
            IndexFactory<I, ?> inner;
            boolean materialize = false;
            boolean norefine = false;
            double kmulti = 1.0;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                Flag flag;
                Flag flag2;
                ObjectParameter objectParameter;
                super.makeOptions(parameterization);
                ObjectParameter objectParameter2 = new ObjectParameter(PROJ_ID, Projection.class);
                if (parameterization.grab(objectParameter2)) {
                    this.proj = (Projection)objectParameter2.instantiateClass(parameterization);
                }
                if (parameterization.grab(objectParameter = new ObjectParameter(INDEX_ID, IndexFactory.class))) {
                    this.inner = (IndexFactory)objectParameter.instantiateClass(parameterization);
                }
                if (parameterization.grab(flag2 = new Flag(MATERIALIZE_FLAG))) {
                    this.materialize = flag2.isTrue();
                }
                if (parameterization.grab(flag = new Flag(DISABLE_REFINE_FLAG))) {
                    this.norefine = flag.isTrue();
                }
                if (!this.norefine) {
                    DoubleParameter doubleParameter = new DoubleParameter(K_MULTIPLIER_ID);
                    doubleParameter.setDefaultValue((Object)1.0);
                    doubleParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_DOUBLE);
                    if (parameterization.grab(doubleParameter)) {
                        this.kmulti = doubleParameter.doubleValue();
                    }
                }
            }

            @Override
            protected Factory<O, I> makeInstance() {
                return new Factory<O, I>(this.proj, this.inner, this.materialize, this.norefine, this.kmulti);
            }
        }
    }

    class ProjectedRKNNQuery
    implements RKNNQuery<O> {
        RKNNQuery<I> inner;
        DistanceQuery<O> distq;

        public ProjectedRKNNQuery(DistanceQuery<O> distanceQuery, RKNNQuery<I> rKNNQuery) {
            this.inner = rKNNQuery;
            this.distq = distanceQuery;
        }

        @Override
        public DoubleDBIDList getRKNNForDBID(DBIDRef dBIDRef, int n) {
            return this.getRKNNForObject(ProjectedIndex.this.relation.get(dBIDRef), n);
        }

        @Override
        public DoubleDBIDList getRKNNForObject(O o, int n) {
            Object i = ProjectedIndex.this.proj.project(o);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getRKNNForObject(i, n);
            }
            DoubleDBIDList doubleDBIDList = this.inner.getRKNNForObject(i, (int)Math.ceil((double)n * ProjectedIndex.this.kmulti));
            ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList(doubleDBIDList.size());
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                double d = this.distq.distance((DoubleDBIDListIter)o, doubleDBIDListIter);
                ProjectedIndex.this.countRefinement();
                modifiableDoubleDBIDList.add(d, doubleDBIDListIter);
                doubleDBIDListIter.advance();
            }
            return modifiableDoubleDBIDList;
        }

        @Override
        public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
            return this.inner.getRKNNForBulkDBIDs(arrayDBIDs, n);
        }
    }

    class ProjectedRangeQuery
    extends AbstractDistanceRangeQuery<O> {
        RangeQuery<I> inner;

        public ProjectedRangeQuery(DistanceQuery<O> distanceQuery, RangeQuery<I> rangeQuery) {
            super(distanceQuery);
            this.inner = rangeQuery;
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            Object i = ProjectedIndex.this.proj.project(o);
            if (ProjectedIndex.this.norefine) {
                this.inner.getRangeForObject(i, d, modifiableDoubleDBIDList);
                return;
            }
            DoubleDBIDList doubleDBIDList = this.inner.getRangeForObject(i, d);
            DoubleDBIDListIter doubleDBIDListIter = doubleDBIDList.iter();
            while (doubleDBIDListIter.valid()) {
                double d2 = this.distanceQuery.distance(o, doubleDBIDListIter);
                ProjectedIndex.this.countRefinement();
                if (d <= d2) {
                    modifiableDoubleDBIDList.add(d2, doubleDBIDListIter);
                }
                doubleDBIDListIter.advance();
            }
        }
    }

    class ProjectedKNNQuery
    implements KNNQuery<O> {
        KNNQuery<I> inner;
        DistanceQuery<O> distq;

        public ProjectedKNNQuery(DistanceQuery<O> distanceQuery, KNNQuery<I> kNNQuery) {
            this.inner = kNNQuery;
            this.distq = distanceQuery;
        }

        @Override
        public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
            return this.getKNNForObject(ProjectedIndex.this.relation.get(dBIDRef), n);
        }

        @Override
        public List<? extends KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
            return this.inner.getKNNForBulkDBIDs(arrayDBIDs, n);
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            Object i = ProjectedIndex.this.proj.project(o);
            if (ProjectedIndex.this.norefine) {
                return this.inner.getKNNForObject(i, n);
            }
            KNNList kNNList = this.inner.getKNNForObject(i, (int)Math.ceil((double)n * ProjectedIndex.this.kmulti));
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                kNNHeap.insert(this.distq.distance((DoubleDBIDListIter)o, doubleDBIDListIter), doubleDBIDListIter);
                ProjectedIndex.this.countRefinement();
                doubleDBIDListIter.advance();
            }
            return kNNHeap.toKNNList();
        }
    }
}

