/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree;

import de.lmu.ifi.dbs.elki.persistent.DefaultPageHeader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.Stack;

public class TreeIndexHeader
extends DefaultPageHeader {
    private static int SIZE = 20;
    int dirCapacity;
    int leafCapacity;
    int dirMinimum;
    int leafMinimum;
    private int emptyPagesSize = 0;
    private int largestPageID = 0;

    public TreeIndexHeader() {
    }

    public TreeIndexHeader(int n, int n2, int n3, int n4, int n5) {
        super(n);
        this.dirCapacity = n2;
        this.leafCapacity = n3;
        this.dirMinimum = n4;
        this.leafMinimum = n5;
    }

    @Override
    public void readHeader(RandomAccessFile randomAccessFile) throws IOException {
        super.readHeader(randomAccessFile);
        this.dirCapacity = randomAccessFile.readInt();
        this.leafCapacity = randomAccessFile.readInt();
        this.dirMinimum = randomAccessFile.readInt();
        this.leafMinimum = randomAccessFile.readInt();
        this.emptyPagesSize = randomAccessFile.readInt();
        this.largestPageID = randomAccessFile.readInt();
    }

    @Override
    public void writeHeader(RandomAccessFile randomAccessFile) throws IOException {
        super.writeHeader(randomAccessFile);
        randomAccessFile.writeInt(this.dirCapacity);
        randomAccessFile.writeInt(this.leafCapacity);
        randomAccessFile.writeInt(this.dirMinimum);
        randomAccessFile.writeInt(this.leafMinimum);
        randomAccessFile.writeInt(this.emptyPagesSize);
        randomAccessFile.writeInt(this.largestPageID);
    }

    public int getDirCapacity() {
        return this.dirCapacity;
    }

    public int getLeafCapacity() {
        return this.leafCapacity;
    }

    public int getDirMinimum() {
        return this.dirMinimum;
    }

    public int getLeafMinimum() {
        return this.leafMinimum;
    }

    public int getEmptyPagesSize() {
        return this.emptyPagesSize;
    }

    public void setEmptyPagesSize(int n) {
        this.emptyPagesSize = n;
    }

    public int getLargestPageID() {
        return this.largestPageID;
    }

    public void setLargestPageID(int n) {
        this.largestPageID = n;
    }

    @Override
    public int size() {
        return super.size() + SIZE;
    }

    public void writeEmptyPages(Stack<Integer> stack, RandomAccessFile randomAccessFile) throws IOException {
        if (stack.size() == 0) {
            this.emptyPagesSize = 0;
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(stack);
        objectOutputStream.flush();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.emptyPagesSize = byArray.length;
        objectOutputStream.close();
        byteArrayOutputStream.close();
        if (this.emptyPagesSize > 0) {
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.write(byArray);
        }
    }

    public Stack<Integer> readEmptyPages(RandomAccessFile randomAccessFile) throws IOException, ClassNotFoundException {
        if (this.emptyPagesSize == 0) {
            return new Stack<Integer>();
        }
        byte[] byArray = new byte[this.emptyPagesSize];
        randomAccessFile.seek(randomAccessFile.length() - (long)this.emptyPagesSize);
        randomAccessFile.read(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Stack stack = (Stack)objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return stack;
    }
}

