/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.Entry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.AbstractMTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.MTreeLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTree;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ApproximationLine;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.ConvexHull;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPLeafEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mkcop.MkCoPTreeNode;
import de.lmu.ifi.dbs.elki.index.tree.query.GenericMTreeDistanceSearchCandidate;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ComparableMinHeap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MkCoPTree<O>
extends AbstractMkTree<O, MkCoPTreeNode<O>, MkCoPEntry, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry>> {
    private static final Logging LOG = Logging.getLogger(MkCoPTree.class);
    private double[] log_k;

    public MkCoPTree(Relation<O> relation, PageFile<MkCoPTreeNode<O>> pageFile, MkTreeSettings<O, MkCoPTreeNode<O>, MkCoPEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
        this.log_k = new double[mkTreeSettings.k_max];
        for (int i = 1; i <= mkTreeSettings.k_max; ++i) {
            this.log_k[i - 1] = Math.log(i);
        }
    }

    @Override
    protected void preInsert(MkCoPEntry mkCoPEntry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insert(MkCoPEntry mkCoPEntry, boolean bl) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insertAll(List<MkCoPEntry> list) {
        if (list.isEmpty()) {
            return;
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("insert " + list + "\n");
        }
        if (!this.initialized) {
            this.initialize((Entry)list.get(0));
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(list.size());
        for (MkCoPEntry mkCoPEntry : list) {
            arrayModifiableDBIDs.add(mkCoPEntry.getRoutingObjectID());
            super.insert(mkCoPEntry, false);
        }
        Map<DBID, KNNList> map = this.batchNN((AbstractMTreeNode)this.getRoot(), arrayModifiableDBIDs, ((MkTreeSettings)this.settings).k_max);
        this.adjustApproximatedKNNDistances((MkCoPEntry)this.getRootEntry(), map);
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef dBIDRef, int n) {
        if (n > ((MkTreeSettings)this.settings).k_max) {
            throw new IllegalArgumentException("Parameter k has to be less or equal than parameter kmax of the MCop-Tree!");
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        this.doReverseKNNQuery(n, dBIDRef, modifiableDoubleDBIDList, arrayModifiableDBIDs);
        Map<DBID, KNNList> map = this.batchNN((AbstractMTreeNode)this.getRoot(), arrayModifiableDBIDs, n);
        modifiableDoubleDBIDList.sort();
        DBIDMIter dBIDMIter = arrayModifiableDBIDs.iter();
        while (dBIDMIter.valid()) {
            DBID dBID = DBIDUtil.deref(dBIDMIter);
            KNNList kNNList = map.get(dBID);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            while (doubleDBIDListIter.valid()) {
                if (DBIDUtil.equal(dBIDRef, doubleDBIDListIter)) {
                    modifiableDoubleDBIDList.add(doubleDBIDListIter.doubleValue(), dBID);
                    break;
                }
                doubleDBIDListIter.advance();
            }
            dBIDMIter.advance();
        }
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    public int getK_max() {
        return ((MkTreeSettings)this.settings).k_max;
    }

    @Override
    protected void initializeCapacities(MkCoPEntry mkCoPEntry) {
        int n = 8;
        double d = 12.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - d) / (8 + n + n + 10) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - d) / (4 + n + 20) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
        this.initialized = true;
        if (LOG.isVerbose()) {
            LOG.verbose("Directory Capacity: " + (this.dirCapacity - 1) + "\nLeaf Capacity:    " + (this.leafCapacity - 1));
        }
    }

    private void doReverseKNNQuery(int n, DBIDRef dBIDRef, ModifiableDoubleDBIDList modifiableDoubleDBIDList, ModifiableDBIDs modifiableDBIDs) {
        ComparableMinHeap<GenericMTreeDistanceSearchCandidate> comparableMinHeap = new ComparableMinHeap<GenericMTreeDistanceSearchCandidate>();
        comparableMinHeap.add(new GenericMTreeDistanceSearchCandidate(0.0, this.getRootID(), null));
        while (!comparableMinHeap.isEmpty()) {
            double d;
            double d2;
            double d3;
            MkCoPEntry mkCoPEntry;
            int n2;
            GenericMTreeDistanceSearchCandidate genericMTreeDistanceSearchCandidate = (GenericMTreeDistanceSearchCandidate)comparableMinHeap.poll();
            MkCoPTreeNode mkCoPTreeNode = (MkCoPTreeNode)this.getNode(genericMTreeDistanceSearchCandidate.nodeID);
            if (!mkCoPTreeNode.isLeaf()) {
                for (n2 = 0; n2 < mkCoPTreeNode.getNumEntries(); ++n2) {
                    mkCoPEntry = (MkCoPEntry)mkCoPTreeNode.getEntry(n2);
                    d3 = this.distance(mkCoPEntry.getRoutingObjectID(), dBIDRef);
                    d2 = mkCoPEntry.getCoveringRadius() > d3 ? 0.0 : d3 - mkCoPEntry.getCoveringRadius();
                    if (!(d2 <= (d = mkCoPEntry.approximateConservativeKnnDistance(n)))) continue;
                    comparableMinHeap.add(new GenericMTreeDistanceSearchCandidate(d2, this.getPageID(mkCoPEntry), mkCoPEntry.getRoutingObjectID()));
                }
                continue;
            }
            for (n2 = 0; n2 < mkCoPTreeNode.getNumEntries(); ++n2) {
                mkCoPEntry = (MkCoPLeafEntry)mkCoPTreeNode.getEntry(n2);
                d3 = this.distance(((MTreeLeafEntry)((Object)mkCoPEntry)).getRoutingObjectID(), dBIDRef);
                if (d3 <= (d2 = ((MkCoPLeafEntry)mkCoPEntry).approximateProgressiveKnnDistance(n))) {
                    modifiableDoubleDBIDList.add(d3, ((MTreeLeafEntry)((Object)mkCoPEntry)).getRoutingObjectID());
                    continue;
                }
                d = ((MkCoPLeafEntry)mkCoPEntry).approximateConservativeKnnDistance(n);
                double d4 = d3 - d;
                if (!(d4 <= 1.0E-10)) continue;
                modifiableDBIDs.add(((MTreeLeafEntry)((Object)mkCoPEntry)).getRoutingObjectID());
            }
        }
    }

    private void adjustApproximatedKNNDistances(MkCoPEntry mkCoPEntry, Map<DBID, KNNList> map) {
        int n;
        MkCoPTreeNode mkCoPTreeNode = (MkCoPTreeNode)this.getNode(mkCoPEntry);
        if (mkCoPTreeNode.isLeaf()) {
            for (n = 0; n < mkCoPTreeNode.getNumEntries(); ++n) {
                MkCoPLeafEntry mkCoPLeafEntry = (MkCoPLeafEntry)mkCoPTreeNode.getEntry(n);
                this.approximateKnnDistances(mkCoPLeafEntry, map.get(mkCoPLeafEntry.getRoutingObjectID()));
            }
        } else {
            for (n = 0; n < mkCoPTreeNode.getNumEntries(); ++n) {
                MkCoPEntry mkCoPEntry2 = (MkCoPEntry)mkCoPTreeNode.getEntry(n);
                this.adjustApproximatedKNNDistances(mkCoPEntry2, map);
            }
        }
        ApproximationLine approximationLine = mkCoPTreeNode.conservativeKnnDistanceApproximation(((MkTreeSettings)this.settings).k_max);
        mkCoPEntry.setConservativeKnnDistanceApproximation(approximationLine);
    }

    private double ssqerr(int n, int n2, double[] dArray, double[] dArray2, double d, double d2) {
        int n3 = n2 - n;
        double d3 = 0.0;
        for (int i = 0; i < n3; ++i) {
            double d4 = dArray2[i] - d * dArray[i] - d2;
            d3 += d4 * d4;
        }
        return d3;
    }

    private double optimize(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6) {
        int n3 = n2 - n + 1;
        return (d5 - d3 * d6 - d4 * d + (double)n3 * d3 * d4) / (d2 - 2.0 * d * d3 + (double)n3 * d3 * d3);
    }

    private void approximateKnnDistances(MkCoPLeafEntry mkCoPLeafEntry, KNNList kNNList) {
        Serializable serializable;
        double d;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = LOG.isDebugging() ? new StringBuilder() : null;
        if (stringBuilder != null) {
            stringBuilder.append("\nknnDistances ").append(kNNList);
        }
        int n = 0;
        for (int i = 0; i < ((MkTreeSettings)this.settings).k_max && (d = kNNList.get(i).doubleValue()) == 0.0; ++i) {
            ++n;
        }
        double[] dArray = new double[((MkTreeSettings)this.settings).k_max - n];
        System.arraycopy(this.log_k, n, dArray, 0, ((MkTreeSettings)this.settings).k_max - n);
        d = 0.0;
        double d2 = 0.0;
        double[] dArray2 = new double[((MkTreeSettings)this.settings).k_max - n];
        for (int i = 0; i < ((MkTreeSettings)this.settings).k_max - n; ++i) {
            double d3 = kNNList.get(i + n).doubleValue();
            dArray2[i] = Math.log(d3);
            d += dArray2[i];
            d2 += dArray2[i] * dArray[i];
        }
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d4 += dArray[i];
            d5 += dArray[i] * dArray[i];
        }
        if (stringBuilder != null) {
            stringBuilder.append("\nk_0 ").append(n);
            stringBuilder.append("\nk_max ").append(((MkTreeSettings)this.settings).k_max);
            stringBuilder.append("\nlog_k(").append(dArray.length).append(") ").append(FormatUtil.format(dArray));
            stringBuilder.append("\nsum_log_k ").append(d4);
            stringBuilder.append("\nsum_log_k^2 ").append(d5);
            stringBuilder.append("\nkDists ").append(kNNList);
            stringBuilder.append("\nlog_kDist(").append(dArray2.length).append(") ").append(FormatUtil.format(dArray2));
            stringBuilder.append("\nsum_log_kDist ").append(d);
            stringBuilder.append("\nsum_log_k_kDist ").append(d2);
        }
        ConvexHull convexHull = new ConvexHull(dArray, dArray2);
        ApproximationLine approximationLine = this.approximateUpperHull(convexHull, dArray, dArray2);
        ApproximationLine approximationLine2 = this.approximateUpperHull_PAPER(convexHull, dArray, d4, d5, dArray2, d, d2);
        double d6 = this.ssqerr(n, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, approximationLine.getM(), approximationLine.getT());
        double d7 = this.ssqerr(n, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, approximationLine2.getM(), approximationLine2.getT());
        if (stringBuilder != null) {
            stringBuilder.append("err1 ").append(d6);
            stringBuilder.append("err2 ").append(d7);
        }
        if (d6 > d7 && d6 - d7 > 1.0E-9) {
            serializable = new StringBuilder();
            int n2 = convexHull.getNumberOfPointsInUpperHull();
            int[] nArray = convexHull.getUpperHull();
            ((StringBuilder)serializable).append("\nentry ").append(mkCoPLeafEntry.getRoutingObjectID());
            ((StringBuilder)serializable).append("\nlower Hull ").append(convexHull.getNumberOfPointsInLowerHull()).append(" ").append(FormatUtil.format(convexHull.getLowerHull()));
            ((StringBuilder)serializable).append("\nupper Hull ").append(convexHull.getNumberOfPointsInUpperHull()).append(" ").append(FormatUtil.format(convexHull.getUpperHull()));
            ((StringBuilder)serializable).append("\nerr1 ").append(d6);
            ((StringBuilder)serializable).append("\nerr2 ").append(d7);
            ((StringBuilder)serializable).append("\nconservative1 ").append(approximationLine);
            ((StringBuilder)serializable).append("\nconservative2 ").append(approximationLine2);
            for (int i = 0; i < n2; ++i) {
                ((StringBuilder)serializable).append("\nlog_k[").append(nArray[i]).append("] = ").append(dArray[nArray[i]]);
                ((StringBuilder)serializable).append("\nlog_kDist[").append(nArray[i]).append("] = ").append(dArray2[nArray[i]]);
            }
        }
        serializable = this.approximateLowerHull(convexHull, dArray, d4, d5, dArray2, d, d2);
        mkCoPLeafEntry.setConservativeKnnDistanceApproximation(approximationLine);
        mkCoPLeafEntry.setProgressiveKnnDistanceApproximation((ApproximationLine)serializable);
        if (stringBuilder != null) {
            LOG.debugFine(stringBuilder.toString());
        }
    }

    private ApproximationLine approximateLowerHull(ConvexHull convexHull, double[] dArray, double d, double d2, double[] dArray2, double d3, double d4) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = convexHull.getLowerHull();
        int n2 = convexHull.getNumberOfPointsInLowerHull();
        int n3 = ((MkTreeSettings)this.settings).k_max - nArray.length + 1;
        stringBuilder.append("lower hull l = ").append(n2).append("\n");
        double d5 = Double.MAX_VALUE;
        double d6 = 0.0;
        double d7 = 0.0;
        for (n = 1; n < n2; ++n) {
            double d8 = (dArray2[nArray[n]] - dArray2[nArray[n - 1]]) / (dArray[nArray[n]] - dArray[nArray[n - 1]]);
            double d9 = dArray2[nArray[n]] - d8 * dArray[nArray[n]];
            double d10 = this.ssqerr(n3, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, d8, d9);
            stringBuilder.append("  Segment = ").append(n).append(" m = ").append(d8).append(" t = ").append(d9).append(" lowerror = ").append(d10).append("\n");
            if (!(d10 < d5)) continue;
            d5 = d10;
            d6 = d8;
            d7 = d9;
        }
        n = 1;
        for (int i = 0; i < n2; ++i) {
            double d11;
            double d12 = this.optimize(n3, ((MkTreeSettings)this.settings).k_max, d, d2, dArray[nArray[i]], dArray2[nArray[i]], d4, d3);
            double d13 = dArray2[nArray[i]] - d12 * dArray[nArray[i]];
            if ((i == 0 || dArray2[nArray[i - 1]] >= dArray2[nArray[i]] - d12 * (dArray[nArray[i]] - dArray[nArray[i - 1]])) && (i == n2 - 1 || dArray2[nArray[i + 1]] >= dArray2[nArray[i]] + d12 * (dArray[nArray[i + 1]] - dArray[nArray[i]])) && (d11 = this.ssqerr(n3, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, d12, d13)) < d5) {
                d5 = d11;
                d6 = d12;
                d7 = d13;
            }
            if (i > 0 && dArray2[nArray[i - 1]] < dArray2[nArray[i]] - d12 * (dArray[nArray[i]] - dArray[nArray[i - 1]]) || n != 0 || i < n2 - 1 && dArray2[nArray[i + 1]] < dArray2[nArray[i]] + d12 * (dArray[nArray[i + 1]] - dArray[nArray[i]])) continue;
            n = 0;
        }
        ApproximationLine approximationLine = new ApproximationLine(n3, d6, d7);
        return approximationLine;
    }

    private ApproximationLine approximateUpperHull(ConvexHull convexHull, double[] dArray, double[] dArray2) {
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = convexHull.getUpperHull();
        int n = convexHull.getNumberOfPointsInUpperHull();
        int n2 = ((MkTreeSettings)this.settings).k_max - nArray.length + 1;
        ApproximationLine approximationLine = null;
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n - 1; ++i) {
            int n3 = nArray[i];
            int n4 = nArray[i + 1];
            double d2 = (dArray2[n4] - dArray2[n3]) / (dArray[n4] - dArray[n3]);
            double d3 = dArray2[n3] - d2 * dArray[n3];
            ApproximationLine approximationLine2 = new ApproximationLine(n2, d2, d3);
            if (LOG.isDebugging()) {
                stringBuilder.append("\nlog_kDist[").append(n4).append("] ").append(dArray2[n4]);
                stringBuilder.append("\nlog_kDist[").append(n3).append("] ").append(dArray2[n3]);
                stringBuilder.append("\nlog_k[").append(n4).append("] ").append(dArray[n4]);
                stringBuilder.append("\nlog_k[").append(n3).append("] ").append(dArray[n3]);
                stringBuilder.append("\n").append(dArray2[n4] - dArray2[n3]);
                stringBuilder.append("\ncurrent_approx_").append(i).append(" ").append(approximationLine2);
            }
            boolean bl = true;
            double d4 = 0.0;
            for (int j = n2; j <= ((MkTreeSettings)this.settings).k_max; ++j) {
                double d5 = approximationLine2.getValueAt(j);
                if (d5 < dArray2[j - n2] && dArray2[j - n2] - d5 > 1.0E-9) {
                    bl = false;
                    break;
                }
                d4 += d5 - dArray2[j - n2];
            }
            if (!bl || !(d4 < d)) continue;
            approximationLine = approximationLine2;
            d = d4;
        }
        if (LOG.isDebugging()) {
            stringBuilder.append("\nupper Approx ").append(approximationLine);
            LOG.debugFine(stringBuilder.toString());
        }
        return approximationLine;
    }

    private ApproximationLine approximateUpperHull_PAPER(ConvexHull convexHull, double[] dArray, double d, double d2, double[] dArray2, double d3, double d4) {
        StringBuilder stringBuilder = LOG.isDebugging() ? new StringBuilder() : null;
        int[] nArray = convexHull.getUpperHull();
        int n = convexHull.getNumberOfPointsInUpperHull();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n2 = ((MkTreeSettings)this.settings).k_max - nArray.length + 1;
        int n3 = n / 2;
        while (arrayList.size() != n) {
            boolean bl;
            arrayList.add(n3);
            double d5 = dArray[nArray[n3]];
            double d6 = dArray2[nArray[n3]];
            double d7 = this.optimize(n2, ((MkTreeSettings)this.settings).k_max, d, d2, d5, d6, d4, d3);
            double d8 = d6 - d7 * d5;
            if (stringBuilder != null) {
                stringBuilder.append("\na=").append(n3).append(" m_a=").append(d7).append(", t_a=").append(d8);
                stringBuilder.append("\n err ").append(this.ssqerr(n2, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, d7, d7));
            }
            double d9 = n3 == 0 ? Double.NaN : dArray[nArray[n3 - 1]];
            double d10 = n3 == 0 ? Double.NaN : dArray2[nArray[n3 - 1]];
            double d11 = n3 == n ? Double.NaN : dArray[nArray[n3 + 1]];
            double d12 = n3 == n ? Double.NaN : dArray2[nArray[n3 + 1]];
            boolean bl2 = n3 == 0 || d10 <= d7 * d9 + d8;
            boolean bl3 = bl = n3 == n || d12 <= d7 * d11 + d8;
            if (bl2 && bl) {
                ApproximationLine approximationLine = new ApproximationLine(n2, d7, d8);
                if (stringBuilder != null) {
                    stringBuilder.append("\n1 anchor = ").append(n3);
                    LOG.debugFine(stringBuilder.toString());
                }
                return approximationLine;
            }
            if (!bl2) {
                if (arrayList.contains(n3 - 1)) {
                    d7 = (d6 - d10) / (d5 - d9);
                    if (d6 == d10) {
                        d7 = 0.0;
                    }
                    d8 = d6 - d7 * d5;
                    ApproximationLine approximationLine = new ApproximationLine(n2, d7, d8);
                    if (stringBuilder != null) {
                        stringBuilder.append("2 anchor = ").append(n3);
                        stringBuilder.append(" appr1 ").append(approximationLine);
                        stringBuilder.append(" x_a ").append(d5).append(", y_a ").append(d6);
                        stringBuilder.append(" x_p ").append(d9).append(", y_p ").append(d10);
                        stringBuilder.append(" a ").append(n3);
                        stringBuilder.append(" upperHull ").append(FormatUtil.format(nArray));
                        LOG.debugFine(stringBuilder.toString());
                    }
                    return approximationLine;
                }
                --n3;
                continue;
            }
            if (arrayList.contains(n3 + 1)) {
                d7 = (d6 - d12) / (d5 - d11);
                if (d6 == d10) {
                    d7 = 0.0;
                }
                d8 = d6 - d7 * d5;
                ApproximationLine approximationLine = new ApproximationLine(n2, d7, d8);
                if (stringBuilder != null) {
                    stringBuilder.append("3 anchor = ").append(n3).append(" -- ").append(n3 + 1);
                    stringBuilder.append(" appr2 ").append(approximationLine);
                    LOG.debugFine(stringBuilder.toString());
                }
                return approximationLine;
            }
            ++n3;
        }
        return null;
    }

    private ApproximationLine approximateUpperHull_OLD(ConvexHull convexHull, double[] dArray, double d, double d2, double[] dArray2, double d3, double d4) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = convexHull.getUpperHull();
        int n2 = convexHull.getNumberOfPointsInUpperHull();
        int n3 = ((MkTreeSettings)this.settings).k_max - nArray.length + 1;
        stringBuilder.append("upper hull:").append(n2);
        double d5 = Double.MAX_VALUE;
        double d6 = 0.0;
        double d7 = 0.0;
        for (n = 1; n < n2; ++n) {
            double d8 = (dArray2[nArray[n]] - dArray2[nArray[n - 1]]) / (dArray[nArray[n]] - dArray[nArray[n - 1]]);
            double d9 = dArray2[nArray[n]] - d8 * dArray[nArray[n]];
            double d10 = this.ssqerr(n3, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, d8, d9);
            if (!(d10 < d5)) continue;
            d5 = d10;
            d6 = d8;
            d7 = d9;
        }
        n = 1;
        for (int i = 0; i < n2; ++i) {
            double d11;
            double d12 = this.optimize(n3, ((MkTreeSettings)this.settings).k_max, d, d2, dArray[nArray[i]], dArray2[nArray[i]], d4, d3);
            double d13 = dArray2[nArray[i]] - d12 * dArray[nArray[i]];
            if ((i == 0 || dArray2[nArray[i - 1]] <= dArray2[nArray[i]] - d12 * (dArray[nArray[i]] - dArray[nArray[i - 1]])) && (i == n2 - 1 || dArray2[nArray[i + 1]] <= dArray2[nArray[i]] + d12 * (dArray[nArray[i + 1]] - dArray[nArray[i]])) && (d11 = this.ssqerr(n3, ((MkTreeSettings)this.settings).k_max, dArray, dArray2, d12, d13)) < d5) {
                d5 = d11;
                d6 = d12;
                d7 = d13;
            }
            if (i > 0 && dArray2[nArray[i - 1]] > dArray2[nArray[i]] - d12 * (dArray[nArray[i]] - dArray[nArray[i - 1]]) || n == 0) {
                // empty if block
            }
            if (i < n2 - 1 && dArray2[nArray[i + 1]] > dArray2[nArray[i]] + d12 * (dArray[nArray[i + 1]] - dArray[nArray[i]])) continue;
            n = 0;
        }
        ApproximationLine approximationLine = new ApproximationLine(n3, d6, d7);
        return approximationLine;
    }

    @Override
    protected MkCoPTreeNode<O> createNewLeafNode() {
        return new MkCoPTreeNode(this.leafCapacity, true);
    }

    @Override
    protected MkCoPTreeNode<O> createNewDirectoryNode() {
        return new MkCoPTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkCoPEntry createNewDirectoryEntry(MkCoPTreeNode<O> mkCoPTreeNode, DBID dBID, double d) {
        return new MkCoPDirectoryEntry(dBID, d, mkCoPTreeNode.getPageID(), mkCoPTreeNode.coveringRadiusFromEntries(dBID, this), null);
    }

    @Override
    protected MkCoPEntry createRootEntry() {
        return new MkCoPDirectoryEntry(null, 0.0, 0, 0.0, null);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

