/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.StatisticalMoments;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLogMOMEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public abstract class AbstractLogMeanVarianceEstimator<D extends Distribution>
extends AbstractLogMOMEstimator<D> {
    @Override
    public D estimateFromLogStatisticalMoments(StatisticalMoments statisticalMoments, double d) {
        if (!(statisticalMoments.getCount() > 1.0)) {
            throw new ArithmeticException("Too small sample size to estimate variance.");
        }
        return this.estimateFromLogMeanVariance(statisticalMoments, d);
    }

    public abstract D estimateFromLogMeanVariance(MeanVariance var1, double var2);

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double d = AbstractLogMOMEstimator.min(a, numberArrayAdapter, 0.0, 1.0E-10);
        MeanVariance meanVariance = new MeanVariance();
        for (int i = 0; i < n; ++i) {
            double d2 = numberArrayAdapter.getDouble(a, i) - d;
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 <= 0.0) continue;
            meanVariance.put(Math.log(d2));
        }
        if (!(meanVariance.getCount() > 1.0)) {
            throw new ArithmeticException("Too small sample size to estimate variance.");
        }
        return this.estimateFromLogMeanVariance(meanVariance, d);
    }
}

