/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.ObjectHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;
import java.util.Comparator;

public class ComparatorMaxHeap<K>
implements ObjectHeap<K> {
    protected Object[] twoheap;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;
    protected Comparator<Object> comparator;

    public ComparatorMaxHeap(Comparator<? super K> comparator) {
        this.comparator = (Comparator)Comparator.class.cast(comparator);
        Object[] objectArray = new Object[31];
        this.twoheap = objectArray;
    }

    public ComparatorMaxHeap(int n, Comparator<? super K> comparator) {
        this.comparator = (Comparator)Comparator.class.cast(comparator);
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        Object[] objectArray = new Object[n2];
        this.twoheap = objectArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(K k) {
        K k2 = k;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
        }
        int n = this.size++;
        this.twoheap[n] = k2;
        this.heapifyUp(n, k2);
    }

    @Override
    public void add(K k, int n) {
        if (this.size < n) {
            this.add(k);
        } else if (this.comparator.compare(this.twoheap[0], k) > 0) {
            this.replaceTopElement(k);
        }
    }

    @Override
    public K replaceTopElement(K k) {
        Object object = this.twoheap[0];
        this.heapifyDown(k);
        return (K)object;
    }

    private void heapifyUp(int n, Object object) {
        int n2;
        Object object2;
        while (n > 0 && this.comparator.compare(object, object2 = this.twoheap[n2 = n - 1 >>> 1]) > 0) {
            this.twoheap[n] = object2;
            n = n2;
        }
        this.twoheap[n] = object;
    }

    @Override
    public K poll() {
        Object object = this.twoheap[0];
        --this.size;
        if (this.size > 0) {
            Object object2 = this.twoheap[this.size];
            this.twoheap[this.size] = null;
            this.heapifyDown(object2);
        } else {
            this.twoheap[0] = null;
        }
        return (K)object;
    }

    private void heapifyDown(Object object) {
        int n = this.size >>> 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = (n2 << 1) + 1;
            Object object2 = this.twoheap[n3];
            int n4 = n3 + 1;
            if (n4 < this.size && this.comparator.compare(object2, this.twoheap[n4]) < 0) {
                n3 = n4;
                object2 = this.twoheap[n4];
            }
            if (this.comparator.compare(object, object2) >= 0) break;
            this.twoheap[n2] = object2;
            n2 = n3;
        }
        this.twoheap[n2] = object;
    }

    @Override
    public K peek() {
        return (K)this.twoheap[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ComparatorMaxHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.get()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements ObjectHeap.UnsortedIter<K> {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < ComparatorMaxHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public K get() {
            return ComparatorMaxHeap.this.twoheap[this.pos];
        }
    }
}

