/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.UpdatableHeap;
import java.util.Comparator;

public class TopBoundedUpdatableHeap<E>
extends UpdatableHeap<E> {
    protected int maxsize;

    public TopBoundedUpdatableHeap(int n) {
        this(n, (Comparator<E>)null);
    }

    public TopBoundedUpdatableHeap(int n, Comparator<? super E> comparator) {
        super(n + 1, comparator);
        this.maxsize = n;
        assert (n > 0);
    }

    @Override
    public void offerAt(int n, E e) {
        if (n != Integer.MIN_VALUE || super.size() < this.maxsize) {
            super.offerAt(n, e);
            return;
        }
        if (this.compare(e, this.queue[0]) < 0) {
            return;
        }
        E e2 = super.replaceTopElement(e);
        this.handleOverflow(e2);
    }

    protected int compare(Object object, Object object2) {
        if (this.comparator == null) {
            Comparable comparable = (Comparable)object;
            return comparable.compareTo(this.queue[0]);
        }
        return this.comparator.compare(object, this.queue[0]);
    }

    protected void handleOverflow(E e) {
    }

    public int getMaxSize() {
        return this.maxsize;
    }
}

