/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.optics;

import de.lmu.ifi.dbs.elki.algorithm.clustering.optics.ClusterOrder;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.utilities.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.batikutil.DragableArea;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSCut;
import de.lmu.ifi.dbs.elki.visualization.opticsplot.OPTICSPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.OPTICSProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.optics.AbstractOPTICSVisualization;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.svg.SVGPoint;

public class OPTICSPlotCutVisualization
extends AbstractVisFactory {
    private static final String NAME = "OPTICS Cut";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<OPTICSProjector> iter = VisualizationTree.filter(visualizerContext, object, OPTICSProjector.class);
        while (iter.valid()) {
            OPTICSProjector oPTICSProjector = iter.get();
            VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, oPTICSProjector.getResult(), null, this);
            visualizationTask.level = 1000;
            visualizerContext.addVis(oPTICSProjector, visualizationTask);
            iter.advance();
        }
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractOPTICSVisualization
    implements DragableArea.DragListener {
        protected static final String CSS_LINE = "opticsPlotLine";
        protected static final String CSS_EPSILON = "opticsPlotEpsilonValue";
        private double epsilon;
        private DragableArea eventarea;
        private Element elemText;
        private Element elementLine;
        private Element elementPoint;

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.epsilon = 0.0;
            this.eventarea = null;
            this.elemText = null;
            this.elementLine = null;
            this.elementPoint = null;
        }

        @Override
        public void fullRedraw() {
            this.incrementalRedraw();
        }

        @Override
        public void incrementalRedraw() {
            if (this.layer == null) {
                this.makeLayerElement();
                this.addCSSClasses();
            }
            String string = this.epsilon > 0.0 ? FormatUtil.NF4.format(this.epsilon) : "";
            double d = this.getYFromEpsilon(this.epsilon);
            if (this.elemText == null) {
                this.elemText = this.svgp.svgText(105.0, d, string);
                SVGUtil.setAtt(this.elemText, "class", CSS_EPSILON);
                this.layer.appendChild(this.elemText);
            } else {
                this.elemText.setTextContent(string);
                SVGUtil.setAtt(this.elemText, "y", d);
            }
            if (this.elementLine == null) {
                this.elementLine = this.svgp.svgLine(0.0, d, 104.0, d);
                SVGUtil.addCSSClass(this.elementLine, CSS_LINE);
                this.layer.appendChild(this.elementLine);
            } else {
                SVGUtil.setAtt(this.elementLine, "y1", d);
                SVGUtil.setAtt(this.elementLine, "y2", d);
            }
            if (this.elementPoint == null) {
                this.elementPoint = this.svgp.svgCircle(104.0, d, 0.4);
                SVGUtil.addCSSClass(this.elementPoint, CSS_LINE);
                this.layer.appendChild(this.elementPoint);
            } else {
                SVGUtil.setAtt(this.elementPoint, "cy", d);
            }
            if (this.eventarea == null) {
                this.eventarea = new DragableArea((SVGPlot)this.svgp, 100.0, -1.0, 10.0, this.plotheight + 2.0, this);
                this.layer.appendChild(this.eventarea.getElement());
            }
        }

        @Override
        public void destroy() {
            super.destroy();
            this.eventarea.destroy();
        }

        protected double getEpsilonFromY(double d) {
            OPTICSPlot oPTICSPlot = this.optics.getOPTICSPlot(this.context);
            d = d < 0.0 ? 0.0 : (d > this.plotheight ? 1.0 : d / this.plotheight);
            return this.optics.getOPTICSPlot(this.context).scaleFromPixel(d * (double)oPTICSPlot.getHeight());
        }

        protected double getYFromEpsilon(double d) {
            OPTICSPlot oPTICSPlot = this.optics.getOPTICSPlot(this.context);
            int n = oPTICSPlot.getHeight();
            double d2 = oPTICSPlot.getScale().getScaled(d, (double)n - 0.5, 0.5) / (double)n * this.plotheight;
            return d2 < 0.0 ? 0.0 : (d2 > this.plotheight ? this.plotheight : d2);
        }

        @Override
        public boolean startDrag(SVGPoint sVGPoint, Event event) {
            this.epsilon = this.getEpsilonFromY(this.plotheight - (double)sVGPoint.getY());
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        @Override
        public boolean duringDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            if (bl) {
                this.epsilon = this.getEpsilonFromY(this.plotheight - (double)sVGPoint2.getY());
            }
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        @Override
        public boolean endDrag(SVGPoint sVGPoint, SVGPoint sVGPoint2, Event event, boolean bl) {
            if (bl) {
                this.epsilon = this.getEpsilonFromY(this.plotheight - (double)sVGPoint2.getY());
                ClusterOrder clusterOrder = this.optics.getResult();
                Clustering<Model> clustering = OPTICSCut.makeOPTICSCut(clusterOrder, this.epsilon);
                clusterOrder.addChildResult(clustering);
            }
            this.svgp.requestRedraw(this.task, this);
            return true;
        }

        public void unsetEpsilon() {
            this.epsilon = 0.0;
        }

        private void addCSSClasses() {
            CSSClass cSSClass;
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            if (!this.svgp.getCSSClassManager().contains(CSS_EPSILON)) {
                cSSClass = new CSSClass(this.svgp, CSS_EPSILON);
                cSSClass.setStatement("fill", styleLibrary.getTextColor("axis.label"));
                cSSClass.setStatement("font-family", styleLibrary.getFontFamily("axis.label"));
                cSSClass.setStatement("font-size", styleLibrary.getTextSize("axis.label"));
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
            if (!this.svgp.getCSSClassManager().contains(CSS_LINE)) {
                cSSClass = new CSSClass(this.svgp, CSS_LINE);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot"));
                cSSClass.setStatement("stroke-width", 0.5 * styleLibrary.getLineWidth("plot"));
                this.svgp.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

