/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.muddle;

import java.util.Collection;
import org.eclipse.epsilon.emc.muddle.Feature;
import org.eclipse.epsilon.emc.muddle.MuddleElement;
import org.eclipse.epsilon.emc.muddle.MuddleFactory;
import org.eclipse.epsilon.emc.muddle.MuddleModel;
import org.eclipse.epsilon.emc.muddle.Slot;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;

public class MuddleModelPropertySetter
extends AbstractPropertySetter {
    protected MuddleModel model;

    public MuddleModelPropertySetter(MuddleModel model) {
        this.model = model;
    }

    @Override
    public void invoke(Object value) throws EolRuntimeException {
        Slot slot;
        MuddleElement element = (MuddleElement)this.object;
        Feature feature = this.getFeature(element, this.property);
        if (feature == null) {
            feature = MuddleFactory.eINSTANCE.createFeature();
            feature.setName(this.property);
            element.getType().getFeatures().add(feature);
            feature.setMany(value instanceof Collection);
            feature.setRuntime(true);
        } else {
            this.model.getUnusedFeatures().remove(feature);
        }
        if (value instanceof Collection) {
            feature.setMany(true);
        }
        if ((slot = this.getSlot(element, feature)) == null) {
            slot = MuddleFactory.eINSTANCE.createSlot();
            slot.setFeature(feature);
            element.getSlots().add(slot);
        }
        slot.getValues().clear();
        if (value instanceof Collection) {
            slot.getValues().addAll((Collection)value);
        } else {
            slot.getValues().add(value);
        }
    }

    protected Slot getSlot(MuddleElement element, Feature feature) {
        for (Slot slot : element.getSlots()) {
            if (slot.getFeature() != feature) continue;
            return slot;
        }
        return null;
    }

    protected Feature getFeature(MuddleElement element, String property) {
        for (Feature feature : element.getType().getFeatures()) {
            if (!feature.getName().equals(property)) continue;
            return feature;
        }
        return null;
    }
}

