/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.coerce;

import org.eclipse.emf.common.util.EList;
import org.eclipse.epsilon.emc.emf.util.EListUtil;
import org.eclipse.epsilon.hutn.model.HutnExtendedFactory;
import org.eclipse.epsilon.hutn.model.hutn.AttributeSlot;
import org.eclipse.epsilon.hutn.model.hutn.ReferenceSlot;
import org.eclipse.epsilon.hutn.xmi.coerce.AbstractCoercionStrategy;

public class ReferenceCoercionStrategy
extends AbstractCoercionStrategy {
    private final String value;

    public ReferenceCoercionStrategy(AttributeSlot slot) {
        super(slot);
        this.value = (String)this.values.get(0);
    }

    @Override
    public boolean isApplicable() {
        return this.slotContainsOneValue() && this.valueIsReference();
    }

    private boolean slotContainsOneValue() {
        return this.values.size() == 1;
    }

    private boolean valueIsReference() {
        return this.value.startsWith("_");
    }

    public ReferenceSlot coerce() {
        ReferenceSlot coercedSlot = HutnExtendedFactory.createReferenceSlot(this.slot.getFeature(), this.slot.getOwner(), this.coercedReferenceValues());
        this.setTraceabilityInformation(coercedSlot);
        this.slot.setOwner(null);
        return coercedSlot;
    }

    private EList<String> coercedReferenceValues() {
        return EListUtil.asEList(this.value.split(" "));
    }

    private void setTraceabilityInformation(ReferenceSlot coercedSlot) {
        coercedSlot.setLine(this.slot.getLine());
        coercedSlot.setCol(this.slot.getCol());
    }
}

