/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique;

import de.lmu.ifi.dbs.elki.algorithm.clustering.subspace.clique.CLIQUEInterval;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import java.util.ArrayList;
import java.util.Iterator;

public class CLIQUEUnit<V extends NumberVector> {
    private ArrayList<CLIQUEInterval> intervals;
    private ModifiableDBIDs ids;
    private boolean assigned;

    private CLIQUEUnit(ArrayList<CLIQUEInterval> arrayList, ModifiableDBIDs modifiableDBIDs) {
        this.intervals = arrayList;
        this.ids = modifiableDBIDs;
        this.assigned = false;
    }

    public CLIQUEUnit(CLIQUEInterval cLIQUEInterval) {
        this.intervals = new ArrayList();
        this.intervals.add(cLIQUEInterval);
        this.ids = DBIDUtil.newHashSet();
        this.assigned = false;
    }

    public boolean contains(V v) {
        for (CLIQUEInterval cLIQUEInterval : this.intervals) {
            double d = v.doubleValue(cLIQUEInterval.getDimension());
            if (!(cLIQUEInterval.getMin() > d) && !(d >= cLIQUEInterval.getMax())) continue;
            return false;
        }
        return true;
    }

    public boolean addFeatureVector(DBIDRef dBIDRef, V v) {
        if (this.contains(v)) {
            this.ids.add(dBIDRef);
            return true;
        }
        return false;
    }

    public int numberOfFeatureVectors() {
        return this.ids.size();
    }

    public double selectivity(double d) {
        return (double)this.ids.size() / d;
    }

    public ArrayList<CLIQUEInterval> getIntervals() {
        return this.intervals;
    }

    public CLIQUEInterval getInterval(int n) {
        for (CLIQUEInterval cLIQUEInterval : this.intervals) {
            if (cLIQUEInterval.getDimension() != n) continue;
            return cLIQUEInterval;
        }
        return null;
    }

    public boolean containsLeftNeighbor(CLIQUEInterval cLIQUEInterval) {
        CLIQUEInterval cLIQUEInterval2 = this.getInterval(cLIQUEInterval.getDimension());
        return cLIQUEInterval2 != null && cLIQUEInterval2.getMax() == cLIQUEInterval.getMin();
    }

    public boolean containsRightNeighbor(CLIQUEInterval cLIQUEInterval) {
        CLIQUEInterval cLIQUEInterval2 = this.getInterval(cLIQUEInterval.getDimension());
        return cLIQUEInterval2 != null && cLIQUEInterval2.getMin() == cLIQUEInterval.getMax();
    }

    public boolean isAssigned() {
        return this.assigned;
    }

    public void markAsAssigned() {
        this.assigned = true;
    }

    public DBIDs getIds() {
        return this.ids;
    }

    public CLIQUEUnit<V> join(CLIQUEUnit<V> cLIQUEUnit, double d, double d2) {
        CLIQUEInterval cLIQUEInterval = this.intervals.get(this.intervals.size() - 1);
        CLIQUEInterval cLIQUEInterval2 = cLIQUEUnit.intervals.get(cLIQUEUnit.intervals.size() - 1);
        if (cLIQUEInterval.getDimension() >= cLIQUEInterval2.getDimension()) {
            return null;
        }
        Iterator<CLIQUEInterval> iterator = this.intervals.iterator();
        Iterator<CLIQUEInterval> iterator2 = cLIQUEUnit.intervals.iterator();
        ArrayList<CLIQUEInterval> arrayList = new ArrayList<CLIQUEInterval>();
        for (int i = 0; i < this.intervals.size() - 1; ++i) {
            cLIQUEInterval = iterator.next();
            if (!cLIQUEInterval.equals(cLIQUEInterval2 = iterator2.next())) {
                return null;
            }
            arrayList.add(cLIQUEInterval);
        }
        arrayList.add(this.intervals.get(this.intervals.size() - 1));
        arrayList.add(cLIQUEUnit.intervals.get(cLIQUEUnit.intervals.size() - 1));
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(this.ids);
        hashSetModifiableDBIDs.retainAll(cLIQUEUnit.ids);
        if ((double)hashSetModifiableDBIDs.size() / d >= d2) {
            return new CLIQUEUnit<V>(arrayList, hashSetModifiableDBIDs);
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CLIQUEInterval cLIQUEInterval : this.intervals) {
            stringBuilder.append(cLIQUEInterval).append(' ');
        }
        return stringBuilder.toString();
    }
}

