/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.ByLabelHierarchicalClustering;
import de.lmu.ifi.dbs.elki.algorithm.clustering.trivial.TrivialAllInOne;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreEvent;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.result.ResultUtil;
import de.lmu.ifi.dbs.elki.result.SelectionResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationProcessor;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class VisualizerContext
implements DataStoreListener,
Result {
    private static final Logging LOG = Logging.getLogger(VisualizerContext.class);
    private VisualizationTree vistree = new VisualizationTree();
    private ResultHierarchy hier;
    private ArrayList<DataStoreListener> listenerList = new ArrayList();
    private Collection<VisualizationProcessor> factories;
    private SelectionResult selection;
    StylingPolicy stylepolicy;
    StyleLibrary stylelibrary;
    private Result baseResult;
    private Relation<?> relation;

    public VisualizerContext(ResultHierarchy resultHierarchy, Result result, Relation<?> relation, StyleLibrary styleLibrary, Collection<VisualizationProcessor> collection) {
        this.hier = resultHierarchy;
        this.baseResult = result;
        this.factories = collection;
        Database database = ResultUtil.findDatabase(resultHierarchy);
        if (database == null) {
            LOG.warning("No database reachable from " + resultHierarchy);
            return;
        }
        ResultUtil.ensureClusteringResult(database, database);
        this.selection = ResultUtil.ensureSelectionResult(database);
        for (Relation<?> relation2 : ResultUtil.getRelations(database)) {
            ResultUtil.getSamplingResult(relation2);
            if (!TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation2.getDataTypeInformation())) continue;
            Relation<?> relation3 = relation2;
            ResultUtil.getScalesResult(relation3);
        }
        this.makeStyleResult(styleLibrary);
        this.notifyFactories(database);
        database.addDataStoreListener(this);
        this.addResultListener(new ResultListener(){

            @Override
            public void resultAdded(Result result, Result result2) {
                VisualizerContext.this.notifyFactories(result);
            }

            @Override
            public void resultChanged(Result result) {
            }

            @Override
            public void resultRemoved(Result result, Result result2) {
            }
        });
    }

    protected void makeStyleResult(StyleLibrary styleLibrary) {
        Database database = ResultUtil.findDatabase(this.hier);
        this.stylelibrary = styleLibrary;
        List<Clustering<? extends Model>> list = ResultUtil.getClusteringResults(database);
        if (list.size() > 0) {
            this.stylepolicy = new ClusterStylingPolicy(list.get(0), styleLibrary);
        } else {
            Clustering<Model> clustering = this.generateDefaultClustering();
            this.stylepolicy = new ClusterStylingPolicy(clustering, styleLibrary);
        }
    }

    public ResultHierarchy getHierarchy() {
        return this.hier;
    }

    public StylingPolicy getStylingPolicy() {
        return this.stylepolicy;
    }

    public void setStylingPolicy(StylingPolicy stylingPolicy) {
        this.stylepolicy = stylingPolicy;
        this.visChanged(stylingPolicy);
    }

    public StyleLibrary getStyleLibrary() {
        return this.stylelibrary;
    }

    public void setStyleLibrary(StyleLibrary styleLibrary) {
        this.stylelibrary = styleLibrary;
    }

    private Clustering<Model> generateDefaultClustering() {
        Database database = ResultUtil.findDatabase(this.hier);
        Result result = null;
        try {
            ByLabelHierarchicalClustering byLabelHierarchicalClustering = new ByLabelHierarchicalClustering();
            result = byLabelHierarchicalClustering.run(database);
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            result = (Clustering)new TrivialAllInOne().run(database);
        }
        return result;
    }

    public SelectionResult getSelectionResult() {
        return this.selection;
    }

    public DBIDSelection getSelection() {
        return this.selection.getSelection();
    }

    public void setSelection(DBIDSelection dBIDSelection) {
        this.selection.setSelection(dBIDSelection);
        this.getHierarchy().resultChanged(this.selection);
    }

    public Relation<?> getRelation() {
        return this.relation;
    }

    public void setRelation(Relation<?> relation) {
        this.relation = relation;
        this.getHierarchy().resultChanged(this);
    }

    public void addDataStoreListener(DataStoreListener dataStoreListener) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            if (this.listenerList.get(i) != dataStoreListener) continue;
            return;
        }
        this.listenerList.add(dataStoreListener);
    }

    public void removeDataStoreListener(DataStoreListener dataStoreListener) {
        this.listenerList.remove(dataStoreListener);
    }

    @Override
    public void contentChanged(DataStoreEvent dataStoreEvent) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            this.listenerList.get(i).contentChanged(dataStoreEvent);
        }
    }

    public void addResultListener(ResultListener resultListener) {
        this.getHierarchy().addResultListener(resultListener);
    }

    public void removeResultListener(ResultListener resultListener) {
        this.getHierarchy().removeResultListener(resultListener);
    }

    public void addVisualizationListener(VisualizationListener visualizationListener) {
        this.vistree.addVisualizationListener(visualizationListener);
    }

    public void removeVisualizationListener(VisualizationListener visualizationListener) {
        this.vistree.removeVisualizationListener(visualizationListener);
    }

    @Override
    public String getLongName() {
        return "Visualizer context";
    }

    @Override
    public String getShortName() {
        return "vis-context";
    }

    public Result getBaseResult() {
        return this.baseResult;
    }

    public void addVis(Object object, VisualizationItem visualizationItem) {
        this.vistree.add(object, visualizationItem);
        this.notifyFactories(visualizationItem);
        this.visChanged(visualizationItem);
    }

    public void visChanged(VisualizationItem visualizationItem) {
        this.vistree.visChanged(visualizationItem);
    }

    private void notifyFactories(Object object) {
        for (VisualizationProcessor visualizationProcessor : this.factories) {
            try {
                visualizationProcessor.processNewResult(this, object);
            }
            catch (Throwable throwable) {
                LOG.warning("VisFactory " + visualizationProcessor.getClass().getCanonicalName() + " failed:", throwable);
            }
        }
    }

    public List<VisualizationTask> getVisTasks(VisualizationItem visualizationItem) {
        ArrayList<VisualizationTask> arrayList = new ArrayList<VisualizationTask>();
        Hierarchy.Iter<VisualizationItem> iter = this.vistree.iterDescendants(visualizationItem);
        while (iter.valid()) {
            VisualizationItem visualizationItem2 = iter.get();
            if (visualizationItem2 instanceof VisualizationTask) {
                arrayList.add((VisualizationTask)visualizationItem2);
            }
            iter.advance();
        }
        return arrayList;
    }

    public VisualizationTree getVisHierarchy() {
        return this.vistree;
    }
}

