/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.workflow;

import de.lmu.ifi.dbs.elki.application.AbstractApplication;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingConfiguration;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.AbstractParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.StringParameter;
import de.lmu.ifi.dbs.elki.workflow.WorkflowStep;
import java.util.logging.Level;

public class LoggingStep
implements WorkflowStep {
    private static final Logging LOG = Logging.getLogger(LoggingStep.class);

    public LoggingStep(int n, String[][] stringArray) {
        if (n <= 0) {
            LoggingConfiguration.setVerbose(Logging.Level.WARNING);
        } else if (n == 1) {
            LoggingConfiguration.setVerbose(Logging.Level.VERBOSE);
        } else if (n > 1) {
            LoggingConfiguration.setVerbose(Logging.Level.VERYVERBOSE);
        }
        if (stringArray != null) {
            for (String[] stringArray2 : stringArray) {
                try {
                    if (stringArray2.length == 1) {
                        try {
                            Level level = Logging.Level.parse(stringArray2[0]);
                            LoggingConfiguration.setDefaultLevel(level);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LoggingConfiguration.setLevelFor(stringArray2[0], Logging.Level.FINEST.getName());
                        }
                        continue;
                    }
                    if (stringArray2.length == 2) {
                        LoggingConfiguration.setLevelFor(stringArray2[0], stringArray2[1]);
                        continue;
                    }
                    throw new AbortException("Invalid logging settings");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOG.warning("Invalid logging statement for package " + stringArray2[0] + ": " + illegalArgumentException.getMessage());
                }
            }
        }
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        protected int verbose = 0;
        protected String[][] levels = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            AbstractParameter abstractParameter;
            super.makeOptions(parameterization);
            Flag flag = new Flag(AbstractApplication.Parameterizer.VERBOSE_ID);
            if (parameterization.grab(flag) && flag.isTrue()) {
                ++this.verbose;
                abstractParameter = new Flag(AbstractApplication.Parameterizer.VERBOSE_ID);
                if (parameterization.grab(abstractParameter) && ((Flag)abstractParameter).isTrue()) {
                    ++this.verbose;
                }
            }
            abstractParameter = new StringParameter(AbstractApplication.Parameterizer.DEBUG_ID);
            abstractParameter.setOptional(true);
            if (parameterization.grab(abstractParameter)) {
                String[] stringArray = ((String)abstractParameter.getValue()).split(",");
                this.levels = new String[stringArray.length][];
                int n = 0;
                for (String string : stringArray) {
                    String[] stringArray2 = string.split("=");
                    if (stringArray2.length != 1 && stringArray2.length != 2) {
                        parameterization.reportError(new WrongParameterValueException(abstractParameter, (String)abstractParameter.getValue(), "Invalid debug option."));
                        break;
                    }
                    this.levels[n] = stringArray2;
                    ++n;
                }
            }
        }

        @Override
        protected LoggingStep makeInstance() {
            return new LoggingStep(this.verbose, this.levels);
        }
    }
}

