/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.config;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epsilon.egl.config.ConfigFileReader;
import org.eclipse.epsilon.egl.config.ContentTypeRepository;
import org.eclipse.epsilon.egl.config.PersistenceException;
import org.eclipse.epsilon.egl.config.XMLConfigFileReader;
import org.eclipse.epsilon.egl.execute.context.IEglContext;
import org.eclipse.epsilon.egl.merge.partition.CompositePartitioner;

public class XMLContentTypeRepository
implements ContentTypeRepository {
    private final ConfigFileReader reader = new XMLConfigFileReader();
    private Map<String, CompositePartitioner> partitioners = new HashMap<String, CompositePartitioner>();

    public XMLContentTypeRepository(IEglContext context) {
        try {
            InputStream defaultConfig = XMLContentTypeRepository.class.getResourceAsStream("DefaultConfig.xml");
            this.load(defaultConfig);
        }
        catch (PersistenceException e) {
            context.getErrorStream().println("Failed to load default content type configuration:");
            context.getErrorStream().print(e.getLocalizedMessage());
        }
    }

    public XMLContentTypeRepository(InputStream config) throws PersistenceException {
        this.load(config);
    }

    @Override
    public void load(InputStream path) throws PersistenceException {
        this.partitioners = this.reader.read(path);
    }

    @Override
    public CompositePartitioner partitionerFor(String contentType) {
        return this.partitioners.get(contentType);
    }
}

