/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.binarySet.BinarySet;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SinglePointCrossover
implements CrossoverOperator<BinarySolution> {
    private double crossoverProbability;
    private JMetalRandom randomGenerator;

    public SinglePointCrossover(double crossoverProbability) {
        if (crossoverProbability < 0.0) {
            throw new JMetalException("Crossover probability is negative: " + crossoverProbability);
        }
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public double getCrossoverProbability() {
        return this.crossoverProbability;
    }

    @Override
    public List<BinarySolution> execute(List<BinarySolution> solutions) {
        if (solutions == null) {
            throw new JMetalException("Null parameter");
        }
        if (solutions.size() != 2) {
            throw new JMetalException("There must be two parents instead of " + solutions.size());
        }
        return this.doCrossover(this.crossoverProbability, solutions.get(0), solutions.get(1));
    }

    public List<BinarySolution> doCrossover(double probability, BinarySolution parent1, BinarySolution parent2) {
        ArrayList<BinarySolution> offspring = new ArrayList<BinarySolution>(2);
        offspring.add((BinarySolution)parent1.copy());
        offspring.add((BinarySolution)parent2.copy());
        if (this.randomGenerator.nextDouble() < probability) {
            int i;
            int bitsAccount;
            int totalNumberOfBits = parent1.getTotalNumberOfBits();
            int crossoverPoint = this.randomGenerator.nextInt(0, totalNumberOfBits - 1);
            int variable = 0;
            for (bitsAccount = ((BinarySet)parent1.getVariableValue(variable)).getBinarySetLength(); bitsAccount < crossoverPoint + 1; bitsAccount += ((BinarySet)parent1.getVariableValue(++variable)).getBinarySetLength()) {
            }
            int diff = bitsAccount - crossoverPoint;
            int intoVariableCrossoverPoint = ((BinarySet)parent1.getVariableValue(variable)).getBinarySetLength() - diff;
            BinarySet offspring1 = (BinarySet)((BinarySet)parent1.getVariableValue(variable)).clone();
            BinarySet offspring2 = (BinarySet)((BinarySet)parent2.getVariableValue(variable)).clone();
            for (i = intoVariableCrossoverPoint; i < offspring1.getBinarySetLength(); ++i) {
                boolean swap = offspring1.get(i);
                offspring1.set(i, offspring2.get(i));
                offspring2.set(i, swap);
            }
            ((BinarySolution)offspring.get(0)).setVariableValue(variable, offspring1);
            ((BinarySolution)offspring.get(1)).setVariableValue(variable, offspring2);
            for (i = variable + 1; i < parent1.getNumberOfVariables(); ++i) {
                ((BinarySolution)offspring.get(0)).setVariableValue(i, parent2.getVariableValue(i));
                ((BinarySolution)offspring.get(1)).setVariableValue(i, parent1.getVariableValue(i));
            }
        }
        return offspring;
    }
}

