/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.pseudorandom.impl;

import org.apache.commons.math3.random.MersenneTwister;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;

public class MersenneTwisterGenerator
implements PseudoRandomGenerator {
    private MersenneTwister rnd;
    private long seed;
    private static final String name = "MersenneTwister";

    public MersenneTwisterGenerator() {
        this.seed = System.currentTimeMillis();
        this.rnd = new MersenneTwister(this.seed);
    }

    public MersenneTwisterGenerator(long seed) {
        this.seed = seed;
        this.rnd = new MersenneTwister(seed);
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public int nextInt(int lowerBound, int upperBound) {
        return lowerBound + this.rnd.nextInt(upperBound - lowerBound + 1);
    }

    @Override
    public double nextDouble(double lowerBound, double upperBound) {
        return lowerBound + this.rnd.nextDouble() * (upperBound - lowerBound);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(0.0, 1.0);
    }

    @Override
    public void setSeed(long seed) {
        this.seed = seed;
        this.rnd.setSeed(seed);
    }

    @Override
    public String getName() {
        return name;
    }
}

