/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.singleobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractIntegerProblem;
import org.uma.jmetal.solution.IntegerSolution;

public class NIntegerMin
extends AbstractIntegerProblem {
    private int valueN;

    public NIntegerMin() {
        this(10, 100, -100, 100);
    }

    public NIntegerMin(int numberOfVariables, int n, int lowerBound, int upperBound) {
        this.valueN = n;
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(1);
        this.setName("NIntegerMin");
        ArrayList<Integer> lowerLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        ArrayList<Integer> upperLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(lowerBound);
            upperLimit.add(upperBound);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(IntegerSolution solution) {
        int approximationToN = 0;
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            int value = (Integer)solution.getVariableValue(i);
            approximationToN += Math.abs(this.valueN - value);
        }
        solution.setObjective(0, approximationToN);
    }
}

