/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.util.FrontUtils;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;
import org.uma.jmetal.util.point.util.DominanceDistance;

public class InvertedGenerationalDistancePlus<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private Front referenceParetoFront;

    public InvertedGenerationalDistancePlus(String referenceParetoFrontFile) throws FileNotFoundException {
        super("IGD+", "Inverted generational distance plus");
        if (referenceParetoFrontFile == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
    }

    public InvertedGenerationalDistancePlus(Front referenceParetoFront) {
        super("IGD+", "Inverted generational distance plus");
        if (referenceParetoFront == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        this.referenceParetoFront = referenceParetoFront;
    }

    @Override
    public Double evaluate(Evaluate solutionList) {
        if (solutionList == null) {
            throw new JMetalException("The pareto front approximation is null");
        }
        return this.invertedGenerationalDistancePlus(new ArrayFront((List<? extends Solution<?>>)solutionList), this.referenceParetoFront);
    }

    public double invertedGenerationalDistancePlus(Front front, Front referenceFront) {
        double sum = 0.0;
        for (int i = 0; i < referenceFront.getNumberOfPoints(); ++i) {
            sum += FrontUtils.distanceToClosestPoint(referenceFront.getPoint(i), front, new DominanceDistance());
        }
        return sum / (double)referenceFront.getNumberOfPoints();
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

