/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.nsgaii;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.algorithm.impl.AbstractGeneticAlgorithm;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.evaluator.SolutionListEvaluator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class NSGAII<S extends Solution<?>>
extends AbstractGeneticAlgorithm<S, List<S>> {
    protected final int maxIterations;
    protected final int populationSize;
    protected final Problem<S> problem;
    protected final SolutionListEvaluator<S> evaluator;
    protected int iterations;

    public NSGAII(Problem<S> problem, int maxIterations, int populationSize, CrossoverOperator<S> crossoverOperator, MutationOperator<S> mutationOperator, SelectionOperator<List<S>, S> selectionOperator, SolutionListEvaluator<S> evaluator) {
        this.problem = problem;
        this.maxIterations = maxIterations;
        this.populationSize = populationSize;
        this.crossoverOperator = crossoverOperator;
        this.mutationOperator = mutationOperator;
        this.selectionOperator = selectionOperator;
        this.evaluator = evaluator;
    }

    @Override
    protected void initProgress() {
        this.iterations = 1;
    }

    @Override
    protected void updateProgress() {
        ++this.iterations;
    }

    @Override
    protected boolean isStoppingConditionReached() {
        return this.iterations >= this.maxIterations;
    }

    @Override
    protected List<S> createInitialPopulation() {
        ArrayList<S> population = new ArrayList<S>(this.populationSize);
        for (int i = 0; i < this.populationSize; ++i) {
            S newIndividual = this.problem.createSolution();
            population.add(newIndividual);
        }
        return population;
    }

    @Override
    protected List<S> evaluatePopulation(List<S> population) {
        population = this.evaluator.evaluate(population, this.problem);
        return population;
    }

    @Override
    protected List<S> selection(List<S> population) {
        ArrayList<Solution> matingPopulation = new ArrayList<Solution>(population.size());
        for (int i = 0; i < this.populationSize; ++i) {
            Solution solution = (Solution)this.selectionOperator.execute(population);
            matingPopulation.add(solution);
        }
        return matingPopulation;
    }

    @Override
    protected List<S> reproduction(List<S> population) {
        ArrayList offspringPopulation = new ArrayList(this.populationSize);
        for (int i = 0; i < this.populationSize; i += 2) {
            ArrayList<S> parents = new ArrayList<S>(2);
            parents.add(population.get(i));
            parents.add(population.get(i + 1));
            List offspring = (List)this.crossoverOperator.execute(parents);
            this.mutationOperator.execute(offspring.get(0));
            this.mutationOperator.execute(offspring.get(1));
            offspringPopulation.add(offspring.get(0));
            offspringPopulation.add(offspring.get(1));
        }
        return offspringPopulation;
    }

    @Override
    protected List<S> replacement(List<S> population, List<S> offspringPopulation) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(population);
        jointPopulation.addAll(offspringPopulation);
        Ranking ranking = this.computeRanking(jointPopulation);
        return this.crowdingDistanceSelection(ranking);
    }

    @Override
    public List<S> getResult() {
        return this.getNonDominatedSolutions(this.getPopulation());
    }

    protected Ranking<S> computeRanking(List<S> solutionList) {
        DominanceRanking<S> ranking = new DominanceRanking<S>();
        ranking.computeRanking(solutionList);
        return ranking;
    }

    protected List<S> crowdingDistanceSelection(Ranking<S> ranking) {
        CrowdingDistance<S> crowdingDistance = new CrowdingDistance<S>();
        ArrayList population = new ArrayList(this.populationSize);
        int rankingIndex = 0;
        while (this.populationIsNotFull(population)) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean populationIsNotFull(List<S> population) {
        return population.size() < this.populationSize;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking<S> ranking, int rank, List<S> population) {
        return ranking.getSubfront(rank).size() < this.populationSize - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> front = ranking.getSubfront(rank);
        for (Solution solution : front) {
            population.add(solution);
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking<S> ranking, int rank, List<S> population) {
        List<S> currentRankedFront = ranking.getSubfront(rank);
        Collections.sort(currentRankedFront, new CrowdingDistanceComparator());
        int i = 0;
        while (population.size() < this.populationSize) {
            population.add(currentRankedFront.get(i));
            ++i;
        }
    }

    protected List<S> getNonDominatedSolutions(List<S> solutionList) {
        return SolutionListUtils.getNondominatedSolutions(solutionList);
    }
}

