/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki;

import de.lmu.ifi.dbs.elki.application.KDDCLIApplication;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.result.ResultHierarchy;
import de.lmu.ifi.dbs.elki.result.SettingsResult;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackParameters;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.TrackedParameter;
import de.lmu.ifi.dbs.elki.workflow.AlgorithmStep;
import de.lmu.ifi.dbs.elki.workflow.EvaluationStep;
import de.lmu.ifi.dbs.elki.workflow.InputStep;
import de.lmu.ifi.dbs.elki.workflow.OutputStep;
import java.util.Collection;

public class KDDTask {
    private Collection<TrackedParameter> settings;
    private InputStep inputStep;
    private AlgorithmStep algorithmStep;
    private EvaluationStep evaluationStep;
    private OutputStep outputStep;
    private ResultHierarchy hier;

    public KDDTask(InputStep inputStep, AlgorithmStep algorithmStep, EvaluationStep evaluationStep, OutputStep outputStep, Collection<TrackedParameter> collection) {
        this.inputStep = inputStep;
        this.algorithmStep = algorithmStep;
        this.evaluationStep = evaluationStep;
        this.outputStep = outputStep;
        this.settings = collection;
    }

    public void run() {
        Database database = this.inputStep.getDatabase();
        this.hier = database.getHierarchy();
        this.algorithmStep.runAlgorithms(database);
        this.hier.add(database, new SettingsResult(this.settings));
        this.evaluationStep.runEvaluators(this.hier, database);
        this.outputStep.runResultHandlers(this.hier, database);
    }

    public ResultHierarchy getResultHierarchy() {
        return this.hier;
    }

    public static void main(String[] stringArray) {
        KDDCLIApplication.runCLIApplication(KDDCLIApplication.class, stringArray);
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        InputStep inputStep = null;
        AlgorithmStep algorithmStep = null;
        EvaluationStep evaluationStep = null;
        Collection<TrackedParameter> settings = null;
        OutputStep outputStep = null;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            TrackParameters trackParameters = new TrackParameters(parameterization);
            this.inputStep = trackParameters.tryInstantiate(InputStep.class);
            this.algorithmStep = trackParameters.tryInstantiate(AlgorithmStep.class);
            this.evaluationStep = trackParameters.tryInstantiate(EvaluationStep.class);
            this.settings = trackParameters.getAllParameters();
            this.outputStep = parameterization.tryInstantiate(OutputStep.class);
        }

        @Override
        protected KDDTask makeInstance() {
            return new KDDTask(this.inputStep, this.algorithmStep, this.evaluationStep, this.outputStep, this.settings);
        }
    }
}

