/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.application.internal;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.ELKIServiceRegistry;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.pairs.Pair;
import de.lmu.ifi.dbs.elki.utilities.xml.HTMLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentReferences {
    private static final String CSSFILE = "stylesheet.css";
    private static final String MODIFICATION_WARNING = "WARNING: THIS DOCUMENT IS AUTOMATICALLY GENERATED. MODIFICATIONS MAY GET LOST.";
    private static final Logging LOG = Logging.getLogger(DocumentReferences.class);
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            String string = object instanceof Class ? ((Class)object).getName() : ((Package)object).getName();
            String string2 = object2 instanceof Class ? ((Class)object2).getName() : ((Package)object2).getName();
            return string.compareTo(string2);
        }
    };

    public static void main(String[] stringArray) {
        Object object;
        FileOutputStream fileOutputStream;
        File file;
        if (stringArray.length < 1 || stringArray.length > 2) {
            LoggingUtil.warning("I need exactly one or two file names to operate!");
            System.exit(1);
        }
        if (!stringArray[0].endsWith(".html") || stringArray.length > 1 && !stringArray[1].endsWith(".trac")) {
            LoggingUtil.warning("File name doesn't end in expected extension!");
            System.exit(1);
        }
        List<Pair<Reference, TreeSet<Object>>> list = DocumentReferences.sortedReferences();
        try {
            file = new File(stringArray[0]);
            fileOutputStream = new FileOutputStream(file);
            object = DocumentReferences.documentReferences(list);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            HTMLUtil.writeXHTML((Document)object, bufferedOutputStream);
            ((OutputStream)bufferedOutputStream).flush();
            ((OutputStream)bufferedOutputStream).close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            LoggingUtil.exception("IO Exception writing HTML output.", iOException);
            throw new RuntimeException(iOException);
        }
        if (stringArray.length > 1) {
            try {
                file = new File(stringArray[1]);
                fileOutputStream = new FileOutputStream(file);
                object = new PrintStream((OutputStream)fileOutputStream, false, "UTF-8");
                DocumentReferences.documentReferencesWiki(list, (PrintStream)object);
                ((PrintStream)object).flush();
                ((PrintStream)object).close();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                LoggingUtil.exception("IO Exception writing Wiki output.", iOException);
                throw new RuntimeException(iOException);
            }
        }
    }

    private static Document documentReferences(List<Pair<Reference, TreeSet<Object>>> list) {
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        Document document = dOMImplementation.createDocument("http://www.w3.org/1999/xhtml", "html", null);
        Element element = document.createElement("head");
        document.getDocumentElement().appendChild(element);
        Element element2 = document.createElement("body");
        document.getDocumentElement().appendChild(element2);
        Node node = document.createComment(MODIFICATION_WARNING);
        element.appendChild(node);
        Comment comment = document.createComment(MODIFICATION_WARNING);
        element2.appendChild(comment);
        node = document.createElement("meta");
        node.setAttribute("http-equiv", "Content-Type");
        node.setAttribute("content", "text/html; charset=UTF-8");
        element.appendChild(node);
        node = document.createElement("link");
        node.setAttribute("rel", "stylesheet");
        node.setAttribute("type", "text/css");
        node.setAttribute("href", CSSFILE);
        element.appendChild(node);
        node = document.createElement("title");
        node.setTextContent("ELKI references overview.");
        element.appendChild(node);
        node = document.createElement("h1");
        node.setTextContent("ELKI references overview:");
        element2.appendChild(node);
        node = document.createElement("dl");
        element2.appendChild(node);
        for (Pair pair : list) {
            Element element3;
            Element element4;
            Object object;
            Object object222;
            Element element5 = document.createElement("dt");
            boolean bl = true;
            for (Object object222 : (TreeSet)pair.second) {
                if (!bl) {
                    element5.appendChild(document.createTextNode(", "));
                }
                if (object222 instanceof Class) {
                    object = (Class)object222;
                    element4 = document.createElement("a");
                    element4.setAttribute("name", ((Class)object).getName());
                    element5.appendChild(element4);
                    element3 = document.createElement("a");
                    element3.setAttribute("href", DocumentReferences.linkForClassName(((Class)object).getName()));
                    element3.setTextContent(((Class)object).getName());
                    element5.appendChild(element3);
                } else if (object222 instanceof Package) {
                    object = (Package)object222;
                    element4 = document.createElement("a");
                    element4.setAttribute("name", ((Package)object).getName());
                    element5.appendChild(element4);
                    element3 = document.createElement("a");
                    element3.setAttribute("href", DocumentReferences.linkForPackageName(((Package)object).getName()));
                    element3.setTextContent(((Package)object).getName());
                    element5.appendChild(element3);
                }
                bl = false;
            }
            node.appendChild(element5);
            Element element6 = document.createElement("dd");
            node.appendChild(element6);
            Reference reference = (Reference)pair.first;
            if (reference.prefix().length() > 0) {
                object222 = document.createElement("div");
                object222.setTextContent(reference.prefix());
                element6.appendChild((Node)object222);
            }
            object222 = document.createElement("div");
            object222.setTextContent(reference.authors());
            element6.appendChild((Node)object222);
            object = document.createElement("div");
            element4 = document.createElement("b");
            element4.setTextContent(reference.title());
            object.appendChild(element4);
            element6.appendChild((Node)object);
            if (reference.booktitle().length() > 0) {
                element3 = document.createElement("div");
                element3.setTextContent("In: " + reference.booktitle());
                if (reference.booktitle().startsWith("Online:")) {
                    element3.setTextContent(reference.booktitle());
                }
                element6.appendChild(element3);
            }
            if (reference.url().length() <= 0) continue;
            element3 = document.createElement("div");
            Element element7 = document.createElement("a");
            element7.setAttribute("href", reference.url());
            element7.setTextContent(reference.url());
            element3.appendChild(element7);
            element6.appendChild(element3);
        }
        return document;
    }

    private static void documentReferencesWiki(List<Pair<Reference, TreeSet<Object>>> list, PrintStream printStream) {
        for (Pair<Reference, TreeSet<Object>> pair : list) {
            boolean bl = true;
            for (Object object : (TreeSet)pair.second) {
                AnnotatedElement annotatedElement;
                if (!bl) {
                    printStream.println(",[[br]]");
                }
                if (object instanceof Class) {
                    annotatedElement = (Class)object;
                    printStream.print("[[javadoc(");
                    printStream.print(((Class)annotatedElement).getName());
                    printStream.print(",");
                    printStream.print(((Class)annotatedElement).getName());
                    printStream.print(")]]");
                } else if (object instanceof Package) {
                    annotatedElement = (Package)object;
                    printStream.print("[[javadoc(");
                    printStream.print(((Package)annotatedElement).getName());
                    printStream.print(",");
                    printStream.print(((Package)annotatedElement).getName());
                    printStream.print(")]]");
                }
                bl = false;
            }
            printStream.println("");
            String string = " ";
            Reference reference = (Reference)pair.first;
            if (reference.prefix().length() > 0) {
                printStream.println(string + reference.prefix() + " [[br]]");
            }
            printStream.println(string + "By: " + reference.authors() + " [[br]]");
            printStream.println(string + "'''" + reference.title() + "'''" + " [[br]]");
            if (reference.booktitle().length() > 0) {
                Object object;
                object = reference.booktitle().startsWith("Online:") ? "" : "In: ";
                printStream.println(string + object + reference.booktitle() + " [[br]]");
            }
            if (reference.url().length() > 0) {
                printStream.println(string + "Online: [" + reference.url() + "][[br]]");
            }
            printStream.println("");
            printStream.println("");
        }
    }

    private static List<Pair<Reference, TreeSet<Object>>> sortedReferences() {
        ArrayList<Pair<Reference, TreeSet<Object>>> arrayList = new ArrayList<Pair<Reference, TreeSet<Object>>>();
        HashMap<Reference, TreeSet<Object>> hashMap = new HashMap<Reference, TreeSet<Object>>();
        HashSet<Package> hashSet = new HashSet<Package>();
        for (Class<?> clazz : ELKIServiceRegistry.findAllImplementations(Object.class, true, false)) {
            DocumentReferences.inspectClass(clazz, arrayList, hashMap);
            if (!hashSet.add(clazz.getPackage())) continue;
            DocumentReferences.inspectPackage(clazz.getPackage(), arrayList, hashMap);
        }
        Collections.sort(arrayList, new Comparator<Pair<Reference, TreeSet<Object>>>(){

            @Override
            public int compare(Pair<Reference, TreeSet<Object>> pair, Pair<Reference, TreeSet<Object>> pair2) {
                Object e = ((TreeSet)pair.second).first();
                Object e2 = ((TreeSet)pair2.second).first();
                int n = COMPARATOR.compare(e, e2);
                if (n == 0) {
                    Reference reference = (Reference)pair.first;
                    Reference reference2 = (Reference)pair2.first;
                    n = this.compareNull(reference.title(), reference2.title());
                    n = n != 0 ? n : this.compareNull(reference.authors(), reference2.authors());
                    n = n != 0 ? n : this.compareNull(reference.booktitle(), reference2.booktitle());
                }
                return n;
            }

            private int compareNull(String string, String string2) {
                return string == string2 ? 0 : (string == null ? -1 : (string2 == null ? 1 : string.compareTo(string2)));
            }
        });
        return arrayList;
    }

    private static void inspectClass(Class<?> clazz, List<Pair<Reference, TreeSet<Object>>> list, Map<Reference, TreeSet<Object>> map) {
        if (clazz.getSimpleName().equals("package-info")) {
            return;
        }
        try {
            Reference reference;
            if (clazz.isAnnotationPresent(Reference.class)) {
                Reference object = clazz.getAnnotation(Reference.class);
                DocumentReferences.addReference(clazz, object, list, map);
            }
            for (Class<?> clazz2 : clazz.getDeclaredClasses()) {
                DocumentReferences.inspectClass(clazz2, list, map);
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Reference.class)) continue;
                reference = method.getAnnotation(Reference.class);
                DocumentReferences.addReference(clazz, reference, list, map);
            }
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Reference.class)) continue;
                reference = field.getAnnotation(Reference.class);
                DocumentReferences.addReference(clazz, reference, list, map);
            }
        }
        catch (Error error) {
            LOG.warning("Exception in finding references for class " + clazz.getCanonicalName() + ": " + error, error);
        }
    }

    private static void addReference(Object object, Reference reference, List<Pair<Reference, TreeSet<Object>>> list, Map<Reference, TreeSet<Object>> map) {
        TreeSet<Object> treeSet = map.get(reference);
        if (treeSet == null) {
            treeSet = new TreeSet<Object>(COMPARATOR);
            map.put(reference, treeSet);
            list.add(new Pair<Reference, TreeSet<Object>>(reference, treeSet));
        }
        treeSet.add(object);
    }

    private static void inspectPackage(Package package_, List<Pair<Reference, TreeSet<Object>>> list, Map<Reference, TreeSet<Object>> map) {
        if (package_.isAnnotationPresent(Reference.class)) {
            Reference reference = package_.getAnnotation(Reference.class);
            DocumentReferences.addReference(package_, reference, list, map);
        }
    }

    private static String linkForClassName(String string) {
        return string.replace(".", "/") + ".html";
    }

    private static String linkForPackageName(String string) {
        return string.replace(".", "/") + "/package-summary.html";
    }

    public static ArrayList<Class<?>> findAllClassesWithReferences() {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz : ELKIServiceRegistry.findAllImplementations(Object.class, true, false)) {
            if (clazz.isAnnotationPresent(Reference.class)) {
                arrayList.add(clazz);
                continue;
            }
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Reference.class)) continue;
                arrayList.add(clazz);
            }
        }
        return arrayList;
    }
}

