/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;

public abstract class AbstractDistanceRangeQuery<O>
implements RangeQuery<O> {
    protected final Relation<? extends O> relation;
    protected final DistanceQuery<O> distanceQuery;

    public AbstractDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
        this.relation = distanceQuery.getRelation();
        this.distanceQuery = distanceQuery;
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef dBIDRef, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(this.relation.get(dBIDRef), d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O o, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.getRangeForObject(o, d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public void getRangeForDBID(DBIDRef dBIDRef, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.getRangeForObject(this.relation.get(dBIDRef), d, modifiableDoubleDBIDList);
    }
}

