/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.random;

import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Random;

@Reference(authors="S. Vigna", title="An experimental exploration of Marsaglia's xorshift generators, scrambled", booktitle="", url="http://vigna.di.unimi.it/ftp/papers/xorshift.pdf")
public class XorShift64NonThreadsafeRandom
extends Random {
    private static final long serialVersionUID = 1L;
    private long x = 4101842887655102017L;

    public XorShift64NonThreadsafeRandom() {
    }

    public XorShift64NonThreadsafeRandom(long l) {
        super(l);
    }

    @Override
    public void setSeed(long l) {
        this.x = l != 0L ? l : 4101842887655102017L;
    }

    @Override
    public long nextLong() {
        this.x ^= this.x >>> 12;
        this.x ^= this.x << 25;
        this.x ^= this.x >>> 27;
        return this.x * 2685821657736338717L;
    }

    @Override
    protected int next(int n) {
        return (int)(this.nextLong() >>> 64 - n);
    }
}

