/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.statistics.distribution.Distribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.ExpMADDistributionEstimator;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;

public abstract class AbstractExpMADEstimator<D extends Distribution>
implements ExpMADDistributionEstimator<D> {
    @Override
    public abstract D estimateFromExpMedianMAD(double var1, double var3);

    @Override
    public <A> D estimate(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        int n = numberArrayAdapter.size(a);
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = Math.exp(numberArrayAdapter.getDouble(a, i));
        }
        double d = QuickSelect.median(dArray);
        double d2 = AbstractExpMADEstimator.computeMAD(dArray, d);
        return this.estimateFromExpMedianMAD(d, d2);
    }

    public static double computeMAD(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = Math.abs(dArray[i] - d);
        }
        double d2 = QuickSelect.median(dArray);
        if (!(d2 > 0.0)) {
            double d3 = Double.POSITIVE_INFINITY;
            for (double d4 : dArray) {
                if (!(d4 > 0.0) || !(d4 < d3)) continue;
                d3 = d4;
            }
            d2 = d3 < Double.POSITIVE_INFINITY ? d3 : 1.0;
        }
        return d2;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

