/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.crossover;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.operator.CrossoverOperator;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class PMXCrossover
implements CrossoverOperator<PermutationSolution<Integer>> {
    private double crossoverProbability = 1.0;
    private JMetalRandom randomGenerator;

    public PMXCrossover(double crossoverProbability) {
        if (crossoverProbability < 0.0 || crossoverProbability > 1.0) {
            throw new JMetalException("Crossover probability value invalid: " + crossoverProbability);
        }
        this.crossoverProbability = crossoverProbability;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    @Override
    public List<PermutationSolution<Integer>> execute(List<PermutationSolution<Integer>> parents) {
        if (null == parents) {
            throw new JMetalException("Null parameter");
        }
        if (parents.size() != 2) {
            throw new JMetalException("There must be two parents instead of " + parents.size());
        }
        return this.doCrossover(this.crossoverProbability, parents);
    }

    public List<PermutationSolution<Integer>> doCrossover(double probability, List<PermutationSolution<Integer>> parents) {
        ArrayList<PermutationSolution<Integer>> offspring = new ArrayList<PermutationSolution<Integer>>(2);
        offspring.add((PermutationSolution)parents.get(0).copy());
        offspring.add((PermutationSolution)parents.get(1).copy());
        int permutationLength = parents.get(0).getNumberOfVariables();
        if (this.randomGenerator.nextDouble() < probability) {
            int i;
            int cuttingPoint1 = this.randomGenerator.nextInt(0, permutationLength - 1);
            int cuttingPoint2 = this.randomGenerator.nextInt(0, permutationLength - 1);
            while (cuttingPoint2 == cuttingPoint1) {
                cuttingPoint2 = this.randomGenerator.nextInt(0, permutationLength - 1);
            }
            if (cuttingPoint1 > cuttingPoint2) {
                int swap = cuttingPoint1;
                cuttingPoint1 = cuttingPoint2;
                cuttingPoint2 = swap;
            }
            int[] replacement1 = new int[permutationLength];
            int[] replacement2 = new int[permutationLength];
            for (i = 0; i < permutationLength; ++i) {
                replacement2[i] = -1;
                replacement1[i] = -1;
            }
            for (i = cuttingPoint1; i <= cuttingPoint2; ++i) {
                ((PermutationSolution)offspring.get(0)).setVariableValue(i, parents.get(1).getVariableValue(i));
                ((PermutationSolution)offspring.get(1)).setVariableValue(i, parents.get(0).getVariableValue(i));
                replacement1[((Integer)parents.get((int)1).getVariableValue((int)i)).intValue()] = (Integer)parents.get(0).getVariableValue(i);
                replacement2[((Integer)parents.get((int)0).getVariableValue((int)i)).intValue()] = (Integer)parents.get(1).getVariableValue(i);
            }
            for (i = 0; i < permutationLength; ++i) {
                if (i >= cuttingPoint1 && i <= cuttingPoint2) continue;
                int n1 = (Integer)parents.get(0).getVariableValue(i);
                int m1 = replacement1[n1];
                int n2 = (Integer)parents.get(1).getVariableValue(i);
                int m2 = replacement2[n2];
                while (m1 != -1) {
                    n1 = m1;
                    m1 = replacement1[m1];
                }
                while (m2 != -1) {
                    n2 = m2;
                    m2 = replacement2[m2];
                }
                ((PermutationSolution)offspring.get(0)).setVariableValue(i, n1);
                ((PermutationSolution)offspring.get(1)).setVariableValue(i, n2);
            }
        }
        return offspring;
    }
}

