/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.io.FileNotFoundException;
import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.naming.impl.SimpleDescribedEntity;

public class R2<Evaluate extends List<? extends Solution<?>>>
extends SimpleDescribedEntity
implements QualityIndicator<Evaluate, Double> {
    private double[][] matrix = null;
    private double[][] lambda = null;
    private Front referenceParetoFront;

    public R2(String referenceParetoFrontFile) throws FileNotFoundException {
        super("R2", "R2 quality indicator");
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
        this.lambda = new double[100][2];
        for (int n = 0; n < 100; ++n) {
            double a;
            this.lambda[n][0] = a = 1.0 * (double)n / 99.0;
            this.lambda[n][1] = 1.0 - a;
        }
    }

    public R2(Front referenceParetoFrontFile) throws FileNotFoundException {
        super("R2", "R2 quality indicator");
        this.referenceParetoFront = referenceParetoFrontFile;
        this.lambda = new double[100][2];
        for (int n = 0; n < 100; ++n) {
            double a;
            this.lambda[n][0] = a = 1.0 * (double)n / 99.0;
            this.lambda[n][1] = 1.0 - a;
        }
    }

    public R2(int nVectors, String referenceParetoFrontFile) throws FileNotFoundException {
        super("R2", "R2 quality indicator");
        ArrayFront front = new ArrayFront(referenceParetoFrontFile);
        this.referenceParetoFront = front;
        this.lambda = new double[nVectors][2];
        for (int n = 0; n < nVectors; ++n) {
            double a;
            this.lambda[n][0] = a = 1.0 * (double)n / (double)(nVectors - 1);
            this.lambda[n][1] = 1.0 - a;
        }
    }

    @Override
    public Double evaluate(Evaluate solutionList) {
        return this.r2(new ArrayFront((List<? extends Solution<?>>)solutionList), this.referenceParetoFront);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public double r2(Front front, Front referenceFront) {
        int numberOfObjectives = front.getPoint(0).getNumberOfDimensions();
        this.matrix = new double[front.getNumberOfPoints()][this.lambda.length];
        for (int i = 0; i < front.getNumberOfPoints(); ++i) {
            for (int j = 0; j < this.lambda.length; ++j) {
                this.matrix[i][j] = this.lambda[j][0] * Math.abs(front.getPoint(i).getDimensionValue(0));
                for (int n = 1; n < numberOfObjectives; ++n) {
                    this.matrix[i][j] = Math.max(this.matrix[i][j], this.lambda[j][n] * Math.abs(front.getPoint(i).getDimensionValue(n)));
                }
            }
        }
        double sum = 0.0;
        for (int i = 0; i < this.lambda.length; ++i) {
            double tmp = this.matrix[0][i];
            for (int j = 1; j < front.getNumberOfPoints(); ++j) {
                tmp = Math.min(tmp, this.matrix[j][i]);
            }
            sum += tmp;
        }
        return sum / (double)this.lambda.length;
    }
}

