/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractIntegerProblem;
import org.uma.jmetal.solution.IntegerSolution;

public class NMMin
extends AbstractIntegerProblem {
    private int valueN;
    private int valueM;

    public NMMin() {
        this(10, 100, -100, -1000, 1000);
    }

    public NMMin(int numberOfVariables, int n, int m, int lowerBound, int upperBound) {
        this.valueN = n;
        this.valueM = m;
        this.setNumberOfVariables(numberOfVariables);
        this.setNumberOfObjectives(2);
        this.setName("NMMin");
        ArrayList<Integer> lowerLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        ArrayList<Integer> upperLimit = new ArrayList<Integer>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(lowerBound);
            upperLimit.add(upperBound);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(IntegerSolution solution) {
        int approximationToN = 0;
        int approximationToM = 0;
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            int value = (Integer)solution.getVariableValue(i);
            approximationToN += Math.abs(this.valueN - value);
            approximationToM += Math.abs(this.valueM - value);
        }
        solution.setObjective(0, approximationToN);
        solution.setObjective(1, approximationToM);
    }
}

