/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.fileoutput;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;

public class SolutionSetOutput {
    public static void printVariablesToFile(FileOutputContext context, List<? extends Solution<?>> solutionSet) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        int numberOfVariables = solutionSet.get(0).getNumberOfVariables();
        try {
            for (int i = 0; i < solutionSet.size(); ++i) {
                for (int j = 0; j < numberOfVariables; ++j) {
                    bufferedWriter.write(solutionSet.get(i).getVariableValueString(j) + context.getSeparator());
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Exception when printing variables to file", e);
        }
    }

    public static void printObjectivesToFile(FileOutputContext context, List<? extends Solution<?>> solutionSet) {
        BufferedWriter bufferedWriter = context.getFileWriter();
        int numberOfObjectives = solutionSet.get(0).getNumberOfObjectives();
        try {
            for (int i = 0; i < solutionSet.size(); ++i) {
                for (int j = 0; j < numberOfObjectives; ++j) {
                    bufferedWriter.write(solutionSet.get(i).getObjective(j) + context.getSeparator());
                }
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (IOException e) {
            throw new JMetalException("Exception when printing objectives to file", e);
        }
    }

    public static void printObjectivesToFile(List<? extends Solution<?>> solutionSet, String fileName) throws IOException {
        SolutionSetOutput.printObjectivesToFile(new DefaultFileOutputContext(fileName), solutionSet);
    }

    public static void printVariablesToFile(List<? extends Solution<?>> solutionSet, String fileName) throws IOException {
        SolutionSetOutput.printVariablesToFile(new DefaultFileOutputContext(fileName), solutionSet);
    }

    public static class Printer {
        private FileOutputContext varFileContext = new DefaultFileOutputContext(this.varFileName);
        private FileOutputContext funFileContext = new DefaultFileOutputContext(this.funFileName);
        private String varFileName = "VAR";
        private String funFileName = "FUN";
        private String separator = "\t";
        private List<? extends Solution<?>> solutionSet;
        private boolean selectFeasibleSolutions;

        public Printer(List<? extends Solution<?>> solutionSet) {
            this.varFileContext.setSeparator(this.separator);
            this.funFileContext.setSeparator(this.separator);
            this.solutionSet = solutionSet;
            this.selectFeasibleSolutions = false;
        }

        public Printer setVarFileOutputContext(FileOutputContext fileContext) {
            this.varFileContext = fileContext;
            return this;
        }

        public Printer setFunFileOutputContext(FileOutputContext fileContext) {
            this.funFileContext = fileContext;
            return this;
        }

        public Printer selectFeasibleSolutions() {
            return this;
        }

        public Printer setSeparator(String separator) {
            this.separator = separator;
            this.varFileContext.setSeparator(this.separator);
            this.funFileContext.setSeparator(this.separator);
            return this;
        }

        public void print() {
            SolutionSetOutput.printObjectivesToFile(this.funFileContext, this.solutionSet);
            SolutionSetOutput.printVariablesToFile(this.varFileContext, this.solutionSet);
        }
    }
}

