/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.parse;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.epsilon.egl.parse.EglRecognitionException;
import org.eclipse.epsilon.egl.parse.EglToken;

public class EglLexer {
    private String program;
    private int col = 1;
    private int line = 1;
    private int index = 0;

    public EglLexer(InputStream is) throws IOException {
        StringBuilder program = new StringBuilder();
        int next = is.read();
        while (next != -1) {
            program.append((char)next);
            next = is.read();
        }
        this.program = program.toString();
    }

    public EglLexer(Reader reader) throws IOException {
        StringBuilder program = new StringBuilder();
        int next = reader.read();
        while (next != -1) {
            program.append((char)next);
            next = reader.read();
        }
        this.program = program.toString();
    }

    public EglLexer(String program) {
        if (program == null) {
            throw new NullPointerException();
        }
        this.program = program;
    }

    public EglToken nextToken() throws EglRecognitionException {
        if (this.program.length() == 0) {
            return this.tokenise(EglToken.TokenType.EOF, "");
        }
        if (this.program.startsWith("\r\n")) {
            return this.tokenise(EglToken.TokenType.NEW_LINE, "\r\n");
        }
        if (this.program.startsWith("\n")) {
            return this.tokenise(EglToken.TokenType.NEW_LINE, "\n");
        }
        if (this.program.startsWith("[*-")) {
            return this.tokenise(EglToken.TokenType.START_MARKER_TAG, "[*-");
        }
        if (this.program.startsWith("[*")) {
            return this.tokenise(EglToken.TokenType.START_COMMENT_TAG, "[*");
        }
        if (this.program.startsWith("*]")) {
            return this.tokenise(EglToken.TokenType.END_COMMENT_TAG, "*]");
        }
        if (this.program.startsWith("[%=")) {
            return this.tokenise(EglToken.TokenType.START_OUTPUT_TAG, "[%=");
        }
        if (this.program.startsWith("[%")) {
            return this.tokenise(EglToken.TokenType.START_TAG, "[%");
        }
        if (this.program.startsWith("%]")) {
            return this.tokenise(EglToken.TokenType.END_TAG, "%]");
        }
        this.index = 0;
        while (this.index < this.program.length()) {
            if (this.programMatches("\n") || this.programMatches("\r\n") || this.programMatches("[%") || this.programMatches("%]") || this.programMatches("[*") || this.programMatches("*]")) {
                return this.tokenise(EglToken.TokenType.PLAIN_TEXT, this.program.substring(0, this.index));
            }
            ++this.index;
        }
        return this.tokenise(EglToken.TokenType.PLAIN_TEXT, this.program);
    }

    private static String unescape(String text) {
        String result = new String(text);
        result = result.replaceAll("\\\\\\[%", "\\[%");
        result = result.replaceAll("\\\\%\\]", "%\\]");
        return result;
    }

    private void newLine() {
        ++this.line;
        this.col = 1;
    }

    private EglToken tokenise(EglToken.TokenType type, String text) {
        EglToken t = type == EglToken.TokenType.PLAIN_TEXT ? new EglToken(type, EglLexer.unescape(text), this.line, this.col) : new EglToken(type, text, this.line, this.col);
        this.program = this.program.substring(text.length());
        this.col += text.length();
        if (type == EglToken.TokenType.NEW_LINE) {
            this.newLine();
        }
        return t;
    }

    private boolean programMatches(String toMatch) {
        return this.programMatches(toMatch, this.index);
    }

    private boolean programMatches(String toMatch, int index) {
        if (index < 0) {
            throw new IllegalStateException("index is less than zero");
        }
        if (index + toMatch.length() > this.program.length()) {
            return false;
        }
        return this.program.substring(index, index + toMatch.length()).equals(toMatch);
    }
}

