/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.introspection.java.ObjectMethod;
import org.eclipse.epsilon.eol.execute.operations.contributors.AnyOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ArrayOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.BasicEUnitOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.BooleanOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.IntegerOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.IterableOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.NumberOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ReflectiveOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.ScalarOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.StringOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.WrapperOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.contributors.compatibility.StringCompatibilityOperationContributor;

public class OperationContributorRegistry {
    private final List<OperationContributor> operationContributorsCache = new ArrayList<OperationContributor>();

    public OperationContributorRegistry() {
        this.operationContributorsCache.addAll(this.getDefaultOperationContributors());
    }

    public void add(OperationContributor operationContributor) {
        this.operationContributorsCache.add(operationContributor);
    }

    protected List<OperationContributor> getDefaultOperationContributors() {
        return new LinkedList<OperationContributor>(Arrays.asList(new StringCompatibilityOperationContributor(), new ReflectiveOperationContributor(), new WrapperOperationContributor(), new StringOperationContributor(), new IntegerOperationContributor(), new NumberOperationContributor(), new BooleanOperationContributor(), new ArrayOperationContributor(), new IterableOperationContributor(), new ScalarOperationContributor(), new AnyOperationContributor(), new BasicEUnitOperationContributor()));
    }

    public ObjectMethod findContributedMethodForUnevaluatedParameters(Object target, String name, IEolContext context) {
        for (OperationContributor c : this.getOperationContributorsFor(target)) {
            ObjectMethod objectMethod = c.findContributedMethodForUnevaluatedParameters(target, name, context);
            if (objectMethod == null) continue;
            return objectMethod;
        }
        return null;
    }

    public ObjectMethod findContributedMethodForEvaluatedParameters(Object target, String name, Object[] parameters, IEolContext context) {
        for (OperationContributor c : this.getOperationContributorsFor(target)) {
            ObjectMethod objectMethod = c.findContributedMethodForEvaluatedParameters(target, name, parameters, context);
            if (objectMethod == null) continue;
            return objectMethod;
        }
        return null;
    }

    private Collection<OperationContributor> getOperationContributorsFor(Object target) {
        LinkedList<OperationContributor> applicableOperationContributors = new LinkedList<OperationContributor>();
        for (OperationContributor c : this.operationContributorsCache) {
            if (!c.contributesTo(target)) continue;
            applicableOperationContributors.add(c);
        }
        return applicableOperationContributors;
    }
}

