/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.clustering.ClusteringAlgorithm;
import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.ClusterModel;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.progress.IndefiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import java.util.ArrayList;
import java.util.List;

@Title(value="DBSCAN: Density-Based Clustering of Applications with Noise")
@Description(value="Algorithm to find density-connected sets in a database based on the parameters 'minpts' and 'epsilon' (specifying a volume). These two parameters determine a density threshold for clustering.")
@Reference(authors="M. Ester, H.-P. Kriegel, J. Sander, X. Xu", title="A Density-Based Algorithm for Discovering Clusters in Large Spatial Databases with Noise", booktitle="Proc. 2nd Int. Conf. on Knowledge Discovery and Data Mining (KDD '96), Portland, OR, 1996", url="http://www.aaai.org/Papers/KDD/1996/KDD96-037")
public class DBSCAN<O>
extends AbstractDistanceBasedAlgorithm<O, Clustering<Model>>
implements ClusteringAlgorithm<Clustering<Model>> {
    private static final Logging LOG = Logging.getLogger(DBSCAN.class);
    protected double epsilon;
    protected int minpts;
    protected List<ModifiableDBIDs> resultList;
    protected ModifiableDBIDs noise;
    protected ModifiableDBIDs processedIDs;
    protected long ncounter;

    public DBSCAN(DistanceFunction<? super O> distanceFunction, double d, int n) {
        super(distanceFunction);
        this.epsilon = d;
        this.minpts = n;
    }

    public Clustering<Model> run(Relation<O> relation) {
        int n = relation.size();
        if (n < this.minpts) {
            Clustering<Model> clustering = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
            clustering.addToplevelCluster(new Cluster<ClusterModel>(relation.getDBIDs(), true, ClusterModel.CLUSTER));
            return clustering;
        }
        RangeQuery<O> rangeQuery = QueryUtil.getRangeQuery(relation, this.getDistanceFunction(), new Object[0]);
        this.resultList = new ArrayList<ModifiableDBIDs>();
        this.noise = DBIDUtil.newHashSet();
        this.runDBSCAN(relation, rangeQuery);
        double d = (double)this.ncounter / (double)relation.size();
        LOG.statistics(new DoubleStatistic(DBSCAN.class.getName() + ".average-neighbors", d));
        if (d < 1.0 + 0.1 * (double)(this.minpts - 1)) {
            LOG.warning("There are very few neighbors found. Epsilon may be too small.");
        }
        if (d > (double)(100 * this.minpts)) {
            LOG.warning("There are very many neighbors found. Epsilon may be too large.");
        }
        Clustering<Model> clustering = new Clustering<Model>("DBSCAN Clustering", "dbscan-clustering");
        for (ModifiableDBIDs modifiableDBIDs : this.resultList) {
            clustering.addToplevelCluster(new Cluster<ClusterModel>((DBIDs)modifiableDBIDs, ClusterModel.CLUSTER));
        }
        clustering.addToplevelCluster(new Cluster<ClusterModel>(this.noise, true, ClusterModel.CLUSTER));
        return clustering;
    }

    protected void runDBSCAN(Relation<O> relation, RangeQuery<O> rangeQuery) {
        int n = relation.size();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Processing objects", n, LOG) : null;
        IndefiniteProgress indefiniteProgress = LOG.isVerbose() ? new IndefiniteProgress("Number of clusters", LOG) : null;
        this.processedIDs = DBIDUtil.newHashSet(n);
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            if (!this.processedIDs.contains(dBIDIter)) {
                this.expandCluster(relation, rangeQuery, dBIDIter, arrayModifiableDBIDs, finiteProgress, indefiniteProgress);
            }
            if (finiteProgress != null && indefiniteProgress != null) {
                finiteProgress.setProcessed(this.processedIDs.size(), LOG);
                indefiniteProgress.setProcessed(this.resultList.size(), LOG);
            }
            if (this.processedIDs.size() == n) break;
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.setCompleted(indefiniteProgress);
    }

    protected void expandCluster(Relation<O> relation, RangeQuery<O> rangeQuery, DBIDRef dBIDRef, ArrayModifiableDBIDs arrayModifiableDBIDs, FiniteProgress finiteProgress, IndefiniteProgress indefiniteProgress) {
        DoubleDBIDList doubleDBIDList = rangeQuery.getRangeForDBID(dBIDRef, this.epsilon);
        this.ncounter += (long)doubleDBIDList.size();
        if (doubleDBIDList.size() < this.minpts) {
            this.noise.add(dBIDRef);
            this.processedIDs.add(dBIDRef);
            if (finiteProgress != null) {
                finiteProgress.incrementProcessed(LOG);
            }
            return;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs2 = DBIDUtil.newArray();
        arrayModifiableDBIDs2.add(dBIDRef);
        this.processedIDs.add(dBIDRef);
        assert (arrayModifiableDBIDs.size() == 0);
        arrayModifiableDBIDs.clear();
        this.processNeighbors(doubleDBIDList.iter(), arrayModifiableDBIDs2, arrayModifiableDBIDs);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        while (!arrayModifiableDBIDs.isEmpty()) {
            doubleDBIDList = rangeQuery.getRangeForDBID(arrayModifiableDBIDs.pop(dBIDVar), this.epsilon);
            this.ncounter += (long)doubleDBIDList.size();
            if (doubleDBIDList.size() >= this.minpts) {
                this.processNeighbors(doubleDBIDList.iter(), arrayModifiableDBIDs2, arrayModifiableDBIDs);
            }
            if (finiteProgress == null) continue;
            finiteProgress.incrementProcessed(LOG);
        }
        this.resultList.add(arrayModifiableDBIDs2);
        if (indefiniteProgress != null) {
            indefiniteProgress.setProcessed(this.resultList.size(), LOG);
        }
    }

    private void processNeighbors(DoubleDBIDListIter doubleDBIDListIter, ModifiableDBIDs modifiableDBIDs, ArrayModifiableDBIDs arrayModifiableDBIDs) {
        boolean bl = this.getDistanceFunction().isMetric();
        while (doubleDBIDListIter.valid()) {
            block8: {
                block7: {
                    block6: {
                        if (!this.processedIDs.add(doubleDBIDListIter)) break block6;
                        if (!bl || doubleDBIDListIter.doubleValue() > 0.0) {
                            arrayModifiableDBIDs.add(doubleDBIDListIter);
                        }
                        break block7;
                    }
                    if (!this.noise.remove(doubleDBIDListIter)) break block8;
                }
                modifiableDBIDs.add(doubleDBIDListIter);
            }
            doubleDBIDListIter.advance();
        }
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID EPSILON_ID = new OptionID("dbscan.epsilon", "The maximum radius of the neighborhood to be considered.");
        public static final OptionID MINPTS_ID = new OptionID("dbscan.minpts", "Threshold for minimum number of points in the epsilon-neighborhood of a point. The suggested value is '2 * dim - 1'.");
        protected double epsilon;
        protected int minpts;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            IntParameter intParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter = (DoubleParameter)new DoubleParameter(EPSILON_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE);
            if (parameterization.grab(doubleParameter)) {
                this.epsilon = (Double)doubleParameter.getValue();
            }
            if (parameterization.grab(intParameter = (IntParameter)new IntParameter(MINPTS_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                this.minpts = (Integer)intParameter.getValue();
                if (this.minpts <= 2) {
                    LOG.warning("DBSCAN with minPts <= 2 is equivalent to single-link clustering at a single height. Consider using larger values of minPts.");
                }
            }
        }

        @Override
        protected DBSCAN<O> makeInstance() {
            return new DBSCAN(this.distanceFunction, this.epsilon, this.minpts);
        }
    }
}

